/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.apicustomizer.service;

import com.streamscape.lib.utils.Pair;
import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerException;
import com.streamscape.sef.network.http.server.apicustomizer.AbstractRuleAccessor;
import com.streamscape.sef.network.http.server.apicustomizer.GenericRule;
import com.streamscape.sef.network.http.server.apicustomizer.ParameterMacros;
import com.streamscape.sef.network.http.server.apicustomizer.eventfabric.AbstractServiceEventRuleWrapper;
import com.streamscape.sef.network.http.server.apicustomizer.service.AbstractServiceRule;
import com.streamscape.sef.network.http.server.apicustomizer.service.ServiceRuleAccessor;
import java.util.List;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;

public class ServiceRuleWrapper
extends AbstractServiceEventRuleWrapper<AbstractServiceRule> {
    private ParameterMacros serviceNameMacros;
    private ParameterMacros eventHandlerMacros;

    public ServiceRuleWrapper(AbstractServiceRule serviceRule) throws APICustomizerException {
        super(serviceRule);
        ServiceRuleWrapper.validateParameterNotNullNotEmpty(serviceRule.getServiceName(), "serviceName");
        this.serviceNameMacros = this.createParameterMacrosIfNotNullNotEmpty(serviceRule.getServiceName());
        this.eventHandlerMacros = this.createParameterMacrosIfNotNullNotEmpty(serviceRule.getEventHandler());
    }

    public ParameterMacros getServiceNameMacros() {
        return this.serviceNameMacros;
    }

    public ParameterMacros getEventHandlerMacros() {
        return this.eventHandlerMacros;
    }

    @Override
    public List<Pair<String, ParameterMacros>> getMacroses() {
        List<Pair<String, ParameterMacros>> result = super.getMacroses();
        this.addIfNotNull(result, "serviceName", this.getServiceNameMacros());
        this.addIfNotNull(result, "eventHandler", this.getEventHandlerMacros());
        return result;
    }

    @Override
    public void validate() throws APICustomizerException {
        super.validate();
        ServiceRuleWrapper.validateParameterNotNullNotEmpty(((AbstractServiceRule)this.getRule()).getServiceName(), "serviceName");
        if (this.eventHandlerMacros == null && this.getEventIdMacros() == null) {
            throw new APICustomizerException("One of eventHandler or eventId should be set.");
        }
        if (this.eventHandlerMacros != null) {
            if (this.getEventIdMacros() != null) {
                throw new APICustomizerException("Only one of eventHandler or eventId should be set.");
            }
            if (this.getCorrelationIdMacros() != null) {
                this.thorwPropertyCannotBeSpecifiedEventHandler("CorrlationId");
            }
            if (this.getDurableMacros() != null) {
                this.thorwPropertyCannotBeSpecifiedEventHandler("Durable");
            }
            if (this.getEventGroupIdMacros() != null) {
                this.thorwPropertyCannotBeSpecifiedEventHandler("EventGroupId");
            }
            if (this.getEventKeyMacros() != null) {
                this.thorwPropertyCannotBeSpecifiedEventHandler("EventKey");
            }
            if (this.getEventPropertiesMacros() != null) {
                this.thorwPropertyCannotBeSpecifiedEventHandler("Event properties");
            }
            if (this.getReplyToMacros() != null) {
                this.thorwPropertyCannotBeSpecifiedEventHandler("ReplyTo");
            }
        }
        if (this.getRule() instanceof GenericRule) {
            if (this.serviceNameMacros != null) {
                this.checkMacroNotSet("serviceName", this.serviceNameMacros, this.serviceNameMacros.isHttpContent() || this.serviceNameMacros.isHttpContentBytes() || this.serviceNameMacros.isUrlQueryParameterMap());
            }
            if (this.eventHandlerMacros != null) {
                this.checkMacroNotSet("eventHandler", this.eventHandlerMacros, this.eventHandlerMacros.isHttpContent() || this.eventHandlerMacros.isHttpContentBytes() || this.eventHandlerMacros.isUrlQueryParameterMap());
            }
        } else {
            this.checkIsValue("serviceName", this.serviceNameMacros);
            this.checkIsValue("eventHandler", this.eventHandlerMacros);
            if (((AbstractServiceRule)this.getRule()).getServiceName().indexOf(46) == -1) {
                throw new APICustomizerException("Invalid serivce name specified '" + ((AbstractServiceRule)this.getRule()).getServiceName() + "'.");
            }
        }
    }

    @Override
    public AbstractRuleAccessor createAccessor(Matcher matcher, HttpServletRequest request) {
        return new ServiceRuleAccessor(this, matcher, request);
    }

    private void thorwPropertyCannotBeSpecifiedEventHandler(String propetyName) throws APICustomizerException {
        throw new APICustomizerException(propetyName + " can be set only with eventId.");
    }
}

