/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.apicustomizer.service;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.PayloadEvent;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerException;
import com.streamscape.sef.network.http.server.apicustomizer.eventfabric.AbstractServiceEventRuleAccessor;
import com.streamscape.sef.network.http.server.apicustomizer.service.ServiceRuleWrapper;
import com.streamscape.sef.service.ServiceContext;
import com.streamscape.service.osf.evh.EventHandler;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;

public class ServiceRuleAccessor
extends AbstractServiceEventRuleAccessor<ServiceRuleWrapper> {
    public ServiceRuleAccessor(ServiceRuleWrapper serviceRuleWrapper, Matcher matcher, HttpServletRequest request) {
        super(serviceRuleWrapper, matcher, request);
    }

    public String getServiceName() throws APICustomizerException {
        return this.parameterMacrosAccessor.getParameterValue(((ServiceRuleWrapper)this.ruleWrapper).getServiceNameMacros(), false);
    }

    public String getEventHandler() throws APICustomizerException {
        return this.parameterMacrosAccessor.getParameterValue(((ServiceRuleWrapper)this.ruleWrapper).getEventHandlerMacros(), true);
    }

    @Override
    protected String parseDataFromUrlContent(String query) throws APICustomizerException {
        String eventId = this.getEventId();
        if (eventId == null || eventId.length() == 0) {
            String serviceName = this.getServiceName();
            FabricComponent component = RuntimeContext.getInstance().lookupComponentByFQName(serviceName);
            if (!(component instanceof ServiceContext)) {
                throw new APICustomizerException("Service '" + serviceName + "' is unavailable or does not exist.");
            }
            ServiceContext serviceContext = (ServiceContext)component;
            ServiceConfigurationObject sco = serviceContext.getServiceConfiguration();
            if (sco == null) {
                throw new APICustomizerException("Failed to get service sco for service '" + serviceName + "'.");
            }
            String eventHandlerName = this.getEventHandler();
            EventHandler eventHandler = null;
            for (EventHandler handler : sco.getEventHandlers()) {
                if (!handler.getHandlerName().equals(eventHandlerName)) continue;
                eventHandler = handler;
                break;
            }
            if (eventHandler == null) {
                throw new APICustomizerException("Failed to get service handler '" + eventHandlerName + "' for service '" + serviceName + "'.");
            }
            eventId = eventHandler.getRequestEventId();
        }
        try {
            EventDatagram event = EventDatagramFactory.getInstance().createEvent(eventId);
            if (!(event instanceof PayloadEvent)) {
                throw new Exception("URL context parameters type supported for payload events only.");
            }
            PayloadEvent payloadEvent = (PayloadEvent)((Object)event);
            Class dataClass = payloadEvent.getPayloadClass();
            String dataClassName = dataClass.getSimpleName();
            StringBuilder builder = new StringBuilder();
            builder.append("{\"").append(dataClassName).append("\":{");
            Iterator<Map.Entry<String, String[]>> iterator = this.request.getParameterMap().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String[]> e;
                Map.Entry<String, String[]> entry = e = iterator.next();
                builder.append("\"").append(entry.getKey()).append("\":").append(entry.getValue()[0]).append(",");
            }
            if (this.request.getParameterMap().entrySet().size() > 0) {
                builder.setLength(builder.length() - 1);
            }
            builder.append("}}");
            ServiceRuleAccessor.setApiCustomizerRequestFormat(this.request, "json");
            return builder.toString();
        }
        catch (Exception exception) {
            throw new APICustomizerException("Failed to parse data from url query: " + exception.getMessage());
        }
    }

    @Override
    protected void onCustomizeQuery(StringBuilder queryBuilder) throws APICustomizerException {
        super.onCustomizeQuery(queryBuilder);
        this.appendIfNotNullNotEmpty(queryBuilder, "service", this.getServiceName());
        String eventHandler = this.getEventHandler();
        String eventId = this.getEventId();
        if (eventHandler != null && eventHandler.length() > 0) {
            this.appendIfNotNullNotEmpty(queryBuilder, "eventHandler", eventHandler);
        } else if (eventId != null && eventId.length() > 0) {
            this.appendIfNotNullNotEmpty(queryBuilder, "eventId", eventId);
        } else {
            throw new APICustomizerException("One of eventHandler or eventId parameters should be set.");
        }
        this.appendIfNotNullNotEmpty(queryBuilder, "data", this.getDataContent());
    }

    @Override
    public String customizeUri() throws APICustomizerException {
        return "/service/invoke";
    }
}

