/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.apicustomizer.eventfabric;

import com.streamscape.lib.utils.Pair;
import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerException;
import com.streamscape.sef.network.http.server.apicustomizer.AbstractRuleAccessor;
import com.streamscape.sef.network.http.server.apicustomizer.ParameterMacros;
import com.streamscape.sef.network.http.server.apicustomizer.eventfabric.AbstractServiceEventRuleWrapper;
import com.streamscape.sef.network.http.server.apicustomizer.eventfabric.EventFabricRule;
import com.streamscape.sef.network.http.server.apicustomizer.eventfabric.EventFabricRuleAccessor;
import java.util.List;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;

class EventFabricRuleWrapper
extends AbstractServiceEventRuleWrapper<EventFabricRule> {
    private ParameterMacros eventOpMacros;
    private ParameterMacros eventContentAsMacros;
    private ParameterMacros eventSelectorMacros;

    public EventFabricRuleWrapper(EventFabricRule eventFabricRule) throws APICustomizerException {
        super(eventFabricRule);
        EventFabricRuleWrapper.validateParameterNotNull((Object)eventFabricRule.getEventOp(), "eventOp");
        this.eventOpMacros = this.createParameterMacrosIfNotNullNotEmpty(eventFabricRule.getEventOp().toString());
        this.eventContentAsMacros = this.createParameterMacrosIfNotNullNotEmpty(eventFabricRule.getEventContentAs());
        this.eventSelectorMacros = this.createParameterMacrosIfNotNullNotEmpty(eventFabricRule.getEventSelector());
    }

    public ParameterMacros getEventOpMacros() {
        return this.eventOpMacros;
    }

    public ParameterMacros getEventContentAsMacros() {
        return this.eventContentAsMacros;
    }

    public ParameterMacros getEventSelectorMacros() {
        return this.eventSelectorMacros;
    }

    @Override
    public List<Pair<String, ParameterMacros>> getMacroses() {
        List<Pair<String, ParameterMacros>> result = super.getMacroses();
        this.addIfNotNull(result, "eventOp", this.getEventOpMacros());
        this.addIfNotNull(result, "eventContentAS", this.getEventContentAsMacros());
        this.addIfNotNull(result, "eventSelector", this.getEventSelectorMacros());
        return result;
    }

    @Override
    public void validate() throws APICustomizerException {
        super.validate();
        EventFabricRuleWrapper.validateParameterNotNull((Object)((EventFabricRule)this.getRule()).getEventOp(), "eventOp");
        if (!this.eventOpMacros.isAsValue()) {
            throw new APICustomizerException("EventOp parameter should be set as value.");
        }
        if (((EventFabricRule)this.getRule()).getEventOp() == EventFabricRule.EventOp.RAISE_EVENT_OP || ((EventFabricRule)this.getRule()).getEventOp() == EventFabricRule.EventOp.RAISE_REQUEST_OP) {
            if (this.eventContentAsMacros != null && this.getDataContentAsMacros() != null) {
                throw new APICustomizerException("Only one of eventDataAs or dataContentAs should be set for raise operations.");
            }
            if (this.getDataContentAsMacros() != null && this.getEventIdMacros() == null) {
                throw new APICustomizerException("If dataContentAs is set the eventId should be set for raise operations.");
            }
            if (this.eventSelectorMacros != null) {
                throw new APICustomizerException("eventSelector cannot be set for raise operations.");
            }
        } else if (this.getEventIdMacros() == null) {
            throw new APICustomizerException("EventId parameter should be set for receive operations.");
        }
        if (this.eventContentAsMacros != null) {
            this.checkMacroNotSet("eventDataAsMacros", this.eventContentAsMacros, this.eventContentAsMacros.isUriFragment() || this.eventContentAsMacros.isUrlQueryParameterMap());
        }
        if (this.eventSelectorMacros != null) {
            this.checkMacroNotSet("eventSelectorMacros", this.eventSelectorMacros, this.eventSelectorMacros.isUriFragment() || this.eventSelectorMacros.isHttpContent() || this.eventSelectorMacros.isHttpContentBytes() || this.eventSelectorMacros.isUrlQueryParameterMap());
        }
    }

    @Override
    public AbstractRuleAccessor createAccessor(Matcher matcher, HttpServletRequest request) {
        return new EventFabricRuleAccessor(this, matcher, request);
    }
}

