/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.apicustomizer.eventfabric;

import com.streamscape.lib.utils.Pair;
import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerException;
import com.streamscape.sef.network.http.server.apicustomizer.AbstractRuleWrapper;
import com.streamscape.sef.network.http.server.apicustomizer.GenericRule;
import com.streamscape.sef.network.http.server.apicustomizer.ParameterMacros;
import com.streamscape.sef.network.http.server.apicustomizer.eventfabric.AbstractServiceEventRule;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractServiceEventRuleWrapper<T extends AbstractServiceEventRule>
extends AbstractRuleWrapper<T> {
    private ParameterMacros dataContentAsMacros;
    private ParameterMacros eventIdMacros;
    private ParameterMacros replyToMacros;
    private ParameterMacros correlationIdMacros;
    private ParameterMacros eventGroupIdMacros;
    private ParameterMacros eventKeyMacros;
    private ParameterMacros durableMacros;
    private ParameterMacros loadBalanceMacros;
    private ParameterMacros timeoutMacros;
    private Map<String, ParameterMacros> eventPropertiesMacros;

    public AbstractServiceEventRuleWrapper(T serviceEventRule) throws APICustomizerException {
        super(serviceEventRule);
        this.eventIdMacros = this.createParameterMacrosIfNotNullNotEmpty(((AbstractServiceEventRule)serviceEventRule).getEventId());
        this.replyToMacros = this.createParameterMacrosIfNotNullNotEmpty(((AbstractServiceEventRule)serviceEventRule).getReplyTo());
        this.dataContentAsMacros = this.createParameterMacrosIfNotNullNotEmpty(((AbstractServiceEventRule)serviceEventRule).getDataContentAs());
        this.correlationIdMacros = this.createParameterMacrosIfNotNullNotEmpty(((AbstractServiceEventRule)serviceEventRule).getCorrelationId());
        this.eventGroupIdMacros = this.createParameterMacrosIfNotNullNotEmpty(((AbstractServiceEventRule)serviceEventRule).getEventGroupId());
        this.eventKeyMacros = this.createParameterMacrosIfNotNullNotEmpty(((AbstractServiceEventRule)serviceEventRule).getEventKey());
        this.durableMacros = this.createParameterMacrosIfNotNullNotEmpty(((AbstractServiceEventRule)serviceEventRule).getDurable());
        this.loadBalanceMacros = this.createParameterMacrosIfNotNullNotEmpty(((AbstractServiceEventRule)serviceEventRule).getLoadBalance());
        this.timeoutMacros = this.createParameterMacrosIfNotNullNotEmpty(((AbstractServiceEventRule)serviceEventRule).getTimeout());
        if (((AbstractServiceEventRule)serviceEventRule).getEventProperties() != null && ((AbstractServiceEventRule)serviceEventRule).getEventProperties().size() > 0) {
            this.eventPropertiesMacros = new HashMap<String, ParameterMacros>();
            for (Map.Entry<Object, Object> entry : ((AbstractServiceEventRule)serviceEventRule).getEventProperties().entrySet()) {
                this.eventPropertiesMacros.put((String)entry.getKey(), this.createParameterMacrosIfNotNull((String)entry.getValue()));
            }
        }
    }

    public ParameterMacros getEventIdMacros() {
        return this.eventIdMacros;
    }

    public ParameterMacros getReplyToMacros() {
        return this.replyToMacros;
    }

    public ParameterMacros getDataContentAsMacros() {
        return this.dataContentAsMacros;
    }

    public ParameterMacros getCorrelationIdMacros() {
        return this.correlationIdMacros;
    }

    public ParameterMacros getEventGroupIdMacros() {
        return this.eventGroupIdMacros;
    }

    public ParameterMacros getEventKeyMacros() {
        return this.eventKeyMacros;
    }

    public ParameterMacros getDurableMacros() {
        return this.durableMacros;
    }

    public Map<String, ParameterMacros> getEventPropertiesMacros() {
        return this.eventPropertiesMacros;
    }

    public ParameterMacros getLoadBalanceMacros() {
        return this.loadBalanceMacros;
    }

    public ParameterMacros getTimeoutMacros() {
        return this.timeoutMacros;
    }

    @Override
    public List<Pair<String, ParameterMacros>> getMacroses() {
        List<Pair<String, ParameterMacros>> result = super.getMacroses();
        this.addIfNotNull(result, "correlationId", this.getCorrelationIdMacros());
        this.addIfNotNull(result, "data", this.getDataContentAsMacros());
        this.addIfNotNull(result, "durable", this.getDurableMacros());
        this.addIfNotNull(result, "eventGroupId", this.getEventGroupIdMacros());
        this.addIfNotNull(result, "eventId", this.getEventIdMacros());
        this.addIfNotNull(result, "eventKey", this.getEventKeyMacros());
        this.addIfNotNull(result, "loadBalance", this.getLoadBalanceMacros());
        this.addIfNotNull(result, "timeout", this.getTimeoutMacros());
        if (this.getEventPropertiesMacros() != null) {
            for (Map.Entry<String, ParameterMacros> entry : this.getEventPropertiesMacros().entrySet()) {
                this.addIfNotNull(result, entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    @Override
    public void validate() throws APICustomizerException {
        block13: {
            block12: {
                super.validate();
                if (this.dataContentAsMacros != null) {
                    this.checkMacroNotSet("dataContentAs", this.dataContentAsMacros, this.dataContentAsMacros.isUriFragment());
                }
                if (!(this.getRule() instanceof GenericRule)) break block12;
                if (this.eventIdMacros != null) {
                    this.checkMacroNotSet("eventId", this.eventIdMacros, this.eventIdMacros.isHttpContent() || this.eventIdMacros.isHttpContentBytes() || this.eventIdMacros.isUrlQueryParameterMap());
                }
                if (this.replyToMacros != null) {
                    this.checkMacroNotSet("replyTo", this.replyToMacros, this.replyToMacros.isHttpContent() || this.replyToMacros.isHttpContentBytes() || this.eventIdMacros.isUrlQueryParameterMap());
                }
                if (this.correlationIdMacros != null) {
                    this.checkMacroNotSet("correlationId", this.correlationIdMacros, this.correlationIdMacros.isHttpContent() || this.correlationIdMacros.isHttpContentBytes() || this.correlationIdMacros.isUrlQueryParameterMap());
                }
                if (this.eventGroupIdMacros != null) {
                    this.checkMacroNotSet("eventGroupId", this.eventGroupIdMacros, this.eventGroupIdMacros.isHttpContent() || this.eventGroupIdMacros.isHttpContentBytes() || this.eventGroupIdMacros.isUrlQueryParameterMap());
                }
                if (this.eventKeyMacros != null) {
                    this.checkMacroNotSet("eventKey", this.eventKeyMacros, this.eventKeyMacros.isHttpContent() || this.eventKeyMacros.isHttpContentBytes() || this.eventKeyMacros.isUrlQueryParameterMap());
                }
                if (this.durableMacros != null) {
                    this.checkMacroNotSet("durable", this.durableMacros, this.durableMacros.isHttpContent() || this.durableMacros.isHttpContentBytes() || this.durableMacros.isUrlQueryParameterMap());
                }
                if (this.loadBalanceMacros != null) {
                    this.checkMacroNotSet("loadBalance", this.loadBalanceMacros, this.loadBalanceMacros.isHttpContent() || this.loadBalanceMacros.isHttpContentBytes() || this.loadBalanceMacros.isUrlQueryParameterMap());
                }
                if (this.timeoutMacros != null) {
                    this.checkMacroNotSet("timeout", this.timeoutMacros, this.timeoutMacros.isHttpContent() || this.timeoutMacros.isHttpContentBytes() || this.timeoutMacros.isUrlQueryParameterMap());
                }
                if (this.eventPropertiesMacros == null) break block13;
                for (Map.Entry<String, ParameterMacros> entry : this.eventPropertiesMacros.entrySet()) {
                    this.checkMacroNotSet("eventProperties." + entry.getKey(), entry.getValue(), entry.getValue().isUrlQueryParameterMap());
                }
                break block13;
            }
            this.checkIsValue("eventId", this.eventIdMacros);
            this.checkIsValue("correlationId", this.correlationIdMacros);
            this.checkIsValue("eventGroupId", this.eventGroupIdMacros);
            this.checkIsValue("eventKey", this.eventKeyMacros);
            this.checkIsValue("loadBalance", this.loadBalanceMacros);
            if (this.eventPropertiesMacros != null) {
                for (Map.Entry<String, ParameterMacros> entry : this.eventPropertiesMacros.entrySet()) {
                    this.checkIsValue("eventProperties" + entry.getKey(), entry.getValue());
                }
            }
        }
    }
}

