/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.apicustomizer.eventfabric;

import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerException;
import com.streamscape.sef.network.http.server.apicustomizer.AbstractRuleAccessor;
import com.streamscape.sef.network.http.server.apicustomizer.ParameterMacros;
import com.streamscape.sef.network.http.server.apicustomizer.eventfabric.AbstractServiceEventRuleWrapper;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;

public abstract class AbstractServiceEventRuleAccessor<T extends AbstractServiceEventRuleWrapper<?>>
extends AbstractRuleAccessor<T> {
    public AbstractServiceEventRuleAccessor(T abstractRuleWrapper, Matcher matcher, HttpServletRequest request) {
        super(abstractRuleWrapper, matcher, request);
    }

    public String getEventId() throws APICustomizerException {
        return this.parameterMacrosAccessor.getParameterValue(((AbstractServiceEventRuleWrapper)this.ruleWrapper).getEventIdMacros(), true);
    }

    public String getReplyTo() throws APICustomizerException {
        return this.parameterMacrosAccessor.getParameterValue(((AbstractServiceEventRuleWrapper)this.ruleWrapper).getReplyToMacros(), true);
    }

    public String getCorrelationId() throws APICustomizerException {
        return this.parameterMacrosAccessor.getParameterValue(((AbstractServiceEventRuleWrapper)this.ruleWrapper).getCorrelationIdMacros(), true);
    }

    public String getEventGroupId() throws APICustomizerException {
        return this.parameterMacrosAccessor.getParameterValue(((AbstractServiceEventRuleWrapper)this.ruleWrapper).getEventGroupIdMacros(), true);
    }

    public String getEventKey() throws APICustomizerException {
        return this.parameterMacrosAccessor.getParameterValue(((AbstractServiceEventRuleWrapper)this.ruleWrapper).getEventKeyMacros(), true);
    }

    public String getDurable() throws APICustomizerException {
        return this.parameterMacrosAccessor.getParameterValue(((AbstractServiceEventRuleWrapper)this.ruleWrapper).getDurableMacros(), true);
    }

    public String getLoadBalance() throws APICustomizerException {
        return this.parameterMacrosAccessor.getParameterValue(((AbstractServiceEventRuleWrapper)this.ruleWrapper).getLoadBalanceMacros(), true);
    }

    public String getTimeout() throws APICustomizerException {
        return this.parameterMacrosAccessor.getParameterValue(((AbstractServiceEventRuleWrapper)this.ruleWrapper).getTimeoutMacros(), true);
    }

    public Map<String, String> getEventProperties() throws APICustomizerException {
        if (((AbstractServiceEventRuleWrapper)this.ruleWrapper).getEventPropertiesMacros() == null || ((AbstractServiceEventRuleWrapper)this.ruleWrapper).getEventPropertiesMacros().size() == 0) {
            return null;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Map.Entry<String, ParameterMacros> entry : ((AbstractServiceEventRuleWrapper)this.ruleWrapper).getEventPropertiesMacros().entrySet()) {
            String value = this.parameterMacrosAccessor.getParameterValue(entry.getValue(), true);
            if (value == null) continue;
            properties.put(entry.getKey(), value);
        }
        return properties;
    }

    public String getDataContent() throws APICustomizerException {
        if (((AbstractServiceEventRuleWrapper)this.ruleWrapper).getDataContentAsMacros() == null) {
            return "";
        }
        String data = this.parameterMacrosAccessor.getParameterValue(((AbstractServiceEventRuleWrapper)this.ruleWrapper).getDataContentAsMacros(), false);
        if (((AbstractServiceEventRuleWrapper)this.ruleWrapper).getDataContentAsMacros().isUrlQueryParameter() || ((AbstractServiceEventRuleWrapper)this.ruleWrapper).getDataContentAsMacros().isHttpContent() || ((AbstractServiceEventRuleWrapper)this.ruleWrapper).getDataContentAsMacros().isHttpHeader() || ((AbstractServiceEventRuleWrapper)this.ruleWrapper).getDataContentAsMacros().isAsValue()) {
            data = this.splitDataAndHints(data);
        } else if (((AbstractServiceEventRuleWrapper)this.ruleWrapper).getDataContentAsMacros().isUrlQueryParameterMap()) {
            data = this.parseDataFromUrlContent(data);
        }
        return data;
    }

    protected abstract String parseDataFromUrlContent(String var1) throws APICustomizerException;

    @Override
    protected void onCustomizeQuery(StringBuilder queryBuilder) throws APICustomizerException {
        this.appendIfNotNullNotEmpty(queryBuilder, "replyTo", this.getReplyTo());
        this.appendIfNotNullNotEmpty(queryBuilder, "correlationId", this.getCorrelationId());
        this.appendIfNotNullNotEmpty(queryBuilder, "eventGroupId", this.getEventGroupId());
        this.appendIfNotNullNotEmpty(queryBuilder, "eventKey", this.getEventKey());
        this.appendIfNotNullNotEmpty(queryBuilder, "durable", this.getDurable());
        this.appendIfNotNullNotEmpty(queryBuilder, "loadBalance", this.getLoadBalance());
        this.appendIfNotNullNotEmpty(queryBuilder, "timeout", this.getTimeout());
        this.appendEventProperties(queryBuilder, this.getEventProperties());
    }

    @Override
    public String customizeMethod() {
        return "GET";
    }

    private void appendEventProperties(StringBuilder builder, Map<String, String> properties) {
        if (properties == null || properties.size() == 0) {
            return;
        }
        builder.append("&").append("eventProperties").append("=");
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            builder.append(HTTPUtils.encodeString(entry.getKey())).append("=").append(HTTPUtils.encodeString(entry.getValue())).append(";");
        }
        builder.setLength(builder.length() - 1);
    }
}

