/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.apicustomizer.dataspace;

import com.streamscape.lib.utils.Pair;
import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerException;
import com.streamscape.sef.network.http.server.apicustomizer.AbstractRuleAccessor;
import com.streamscape.sef.network.http.server.apicustomizer.GenericRule;
import com.streamscape.sef.network.http.server.apicustomizer.ParameterMacros;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.AbstractDataspaceRuleWrapper;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.DataspaceQueueRule;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.DataspaceQueueRuleAccessor;
import java.util.List;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;

public class DataspaceQueueRuleWrapper
extends AbstractDataspaceRuleWrapper<DataspaceQueueRule> {
    private ParameterMacros queueNameMacros;
    private ParameterMacros objectMacros;
    private ParameterMacros selectorMacros;

    public DataspaceQueueRuleWrapper(DataspaceQueueRule dataspaceRule) throws APICustomizerException {
        super(dataspaceRule);
        DataspaceQueueRuleWrapper.validateParameterNotNullNotEmpty(dataspaceRule.getQueueName(), "queueName");
        DataspaceQueueRuleWrapper.validateParameterNotNull((Object)dataspaceRule.getOperation(), "operation");
        this.queueNameMacros = this.createParameterMacrosIfNotNullNotEmpty(dataspaceRule.getQueueName());
        this.objectMacros = this.createParameterMacrosIfNotNullNotEmpty(dataspaceRule.getObject());
        this.selectorMacros = this.createParameterMacrosIfNotNullNotEmpty(dataspaceRule.getSelector());
    }

    public ParameterMacros getQueueNameMacros() {
        return this.queueNameMacros;
    }

    public ParameterMacros getObjectMacros() {
        return this.objectMacros;
    }

    public ParameterMacros getSelectorMacros() {
        return this.selectorMacros;
    }

    @Override
    public List<Pair<String, ParameterMacros>> getMacroses() {
        List<Pair<String, ParameterMacros>> result = super.getMacroses();
        this.addIfNotNull(result, "queueName", this.getQueueNameMacros());
        this.addIfNotNull(result, "data", this.getObjectMacros());
        this.addIfNotNull(result, "where", this.getSelectorMacros());
        return result;
    }

    @Override
    public void validate() throws APICustomizerException {
        super.validate();
        DataspaceQueueRuleWrapper.validateParameterNotNullNotEmpty(((DataspaceQueueRule)this.getRule()).getQueueName(), "queueName");
        DataspaceQueueRuleWrapper.validateParameterNotNull((Object)((DataspaceQueueRule)this.getRule()).getOperation(), "operaiton");
        switch (((DataspaceQueueRule)this.getRule()).getOperation()) {
            case PUT: {
                if (this.selectorMacros != null) {
                    throw new APICustomizerException("Invalid 'selector' parameter value. Parameter 'selector' is not allowed for PUT into queue operation.");
                }
                if (this.objectMacros != null) break;
                throw new APICustomizerException("Invalid 'object' parameter value. Parameter 'object' should be set for PUT into queue operation.");
            }
            case TAKE: 
            case READ: {
                if (this.objectMacros == null) break;
                throw new APICustomizerException("Invalid 'object' parameter value. Parameter 'object' is not allowed for READ/TAKE from queue operations.");
            }
            default: {
                throw new APICustomizerException("Unsupported operation " + ((DataspaceQueueRule)this.getRule()).getOperation().toString());
            }
        }
        if (this.getRule() instanceof GenericRule) {
            if (this.queueNameMacros != null) {
                this.checkMacroNotSet("queueName", this.queueNameMacros, this.queueNameMacros.isHttpContent() || this.queueNameMacros.isHttpContentBytes() || this.queueNameMacros.isUrlQueryParameterMap());
            }
            if (this.selectorMacros != null) {
                this.checkMacroNotSet("selector", this.selectorMacros, this.selectorMacros.isHttpContent() || this.selectorMacros.isHttpContentBytes() || this.selectorMacros.isUrlQueryParameterMap());
            }
            if (this.objectMacros != null) {
                this.checkMacroNotSet("object", this.objectMacros, this.objectMacros.isUriFragment());
            }
        } else {
            this.checkIsValue("queueName", this.queueNameMacros);
            this.checkIsValue("selector", this.selectorMacros);
            this.checkIsValue("object", this.objectMacros);
        }
    }

    @Override
    public AbstractRuleAccessor createAccessor(Matcher matcher, HttpServletRequest request) {
        return new DataspaceQueueRuleAccessor(this, matcher, request);
    }
}

