/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.apicustomizer.dataspace;

import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerException;
import com.streamscape.sef.network.http.server.apicustomizer.ParameterMacrosProcessor;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.AbstractDataspaceRuleAccessor;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.DataspaceQueueRule;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.DataspaceQueueRuleWrapper;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;

class DataspaceQueueRuleAccessor
extends AbstractDataspaceRuleAccessor<DataspaceQueueRuleWrapper> {
    public DataspaceQueueRuleAccessor(DataspaceQueueRuleWrapper dataspaceRuleWrapper, Matcher matcher, HttpServletRequest request) {
        super(dataspaceRuleWrapper, matcher, request);
    }

    public String getQueueName() throws APICustomizerException {
        return this.parameterMacrosAccessor.getParameterValue(((DataspaceQueueRuleWrapper)this.ruleWrapper).getQueueNameMacros(), false);
    }

    public String getSelector() throws APICustomizerException {
        return this.parameterMacrosAccessor.getParameterValue(((DataspaceQueueRuleWrapper)this.ruleWrapper).getSelectorMacros(), true);
    }

    public String getObject() throws APICustomizerException {
        if (((DataspaceQueueRuleWrapper)this.ruleWrapper).getObjectMacros() == null) {
            return "";
        }
        String object = this.parameterMacrosAccessor.getParameterValue(((DataspaceQueueRuleWrapper)this.ruleWrapper).getObjectMacros(), "data", false, false);
        return this.splitDataAndHints(object);
    }

    @Override
    public String customizeMethod() throws APICustomizerException {
        switch (((DataspaceQueueRule)((DataspaceQueueRuleWrapper)this.ruleWrapper).getRule()).getOperation()) {
            case PUT: {
                return "POST";
            }
            case TAKE: {
                return "DELETE";
            }
            case READ: {
                return "GET";
            }
        }
        throw new APICustomizerException("Unknown operation " + String.valueOf((Object)((DataspaceQueueRule)((DataspaceQueueRuleWrapper)this.ruleWrapper).getRule()).getOperation()));
    }

    @Override
    public String customizeUri() throws APICustomizerException {
        return super.customizeUri() + "/" + this.getQueueName();
    }

    @Override
    protected void onCustomizeQuery(StringBuilder queryBuilder) throws APICustomizerException {
        super.onCustomizeQuery(queryBuilder);
        switch (((DataspaceQueueRule)((DataspaceQueueRuleWrapper)this.ruleWrapper).getRule()).getOperation()) {
            case PUT: {
                String object = this.getObject();
                if (ParameterMacrosProcessor.shouldSkip(object)) break;
                this.append(queryBuilder, "data", object);
                break;
            }
            case TAKE: 
            case READ: {
                this.appendIfNotNullNotEmpty(queryBuilder, "where", this.getSelector());
                break;
            }
            default: {
                throw new APICustomizerException("Unknown operation " + String.valueOf((Object)((DataspaceQueueRule)((DataspaceQueueRuleWrapper)this.ruleWrapper).getRule()).getOperation()));
            }
        }
    }
}

