/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.apicustomizer.dataspace;

import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerException;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.AbstractDataspaceRuleAccessor;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.DataspaceODataRuleWrapper;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;

public class DataspaceODataRuleAccessor
extends AbstractDataspaceRuleAccessor<DataspaceODataRuleWrapper> {
    public DataspaceODataRuleAccessor(DataspaceODataRuleWrapper dataspaceODataRuleWrapper, Matcher matcher, HttpServletRequest request) {
        super(dataspaceODataRuleWrapper, matcher, request);
    }

    @Override
    protected void onCustomizeQuery(StringBuilder queryBuilder) throws APICustomizerException {
        String query = this.request.getQueryString();
        if (query != null && query.length() > 0) {
            queryBuilder.append("?").append(query);
        }
        super.onCustomizeQuery(queryBuilder);
    }

    @Override
    public String customizeMethod() throws APICustomizerException {
        return this.request.getMethod();
    }

    @Override
    public String customizeUri() throws APICustomizerException {
        String uri = "/odata/v4/" + this.getDataspaceName();
        String uriTail = this.getUriTail();
        if (uriTail != null && uriTail.length() > 0) {
            if (!uriTail.startsWith("/")) {
                uri = uri + "/";
            }
            uri = uri + uriTail;
        }
        return uri;
    }
}

