/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.apicustomizer.dataspace;

import com.streamscape.lib.utils.Pair;
import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerException;
import com.streamscape.sef.network.http.server.apicustomizer.AbstractRuleAccessor;
import com.streamscape.sef.network.http.server.apicustomizer.GenericRule;
import com.streamscape.sef.network.http.server.apicustomizer.ParameterMacros;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.AbstractDataspaceRuleWrapper;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.DataspaceFunctionRule;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.DataspaceFunctionRuleAccessor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;

public class DataspaceFunctionRuleWrapper
extends AbstractDataspaceRuleWrapper<DataspaceFunctionRule> {
    private ParameterMacros functionNameMacros;
    private Map<String, ParameterMacros> parametersMacros = new HashMap<String, ParameterMacros>();

    public DataspaceFunctionRuleWrapper(DataspaceFunctionRule dataspaceFunctionRule) throws APICustomizerException {
        super(dataspaceFunctionRule);
        DataspaceFunctionRuleWrapper.validateParameterNotNullNotEmpty(dataspaceFunctionRule.getFunctionName(), "functionName");
        this.functionNameMacros = this.createParameterMacrosIfNotNullNotEmpty(dataspaceFunctionRule.getFunctionName());
        if (dataspaceFunctionRule.getParameters() != null && dataspaceFunctionRule.getParameters().size() > 0) {
            this.parametersMacros = new HashMap<String, ParameterMacros>();
            for (Map.Entry<Object, Object> entry : dataspaceFunctionRule.getParameters().entrySet()) {
                this.parametersMacros.put((String)entry.getKey(), this.createParameterMacrosIfNotNull((String)entry.getValue()));
            }
        }
    }

    public ParameterMacros getFunctionNameMacros() {
        return this.functionNameMacros;
    }

    public Map<String, ParameterMacros> getParametersMacros() {
        return this.parametersMacros;
    }

    @Override
    public List<Pair<String, ParameterMacros>> getMacroses() {
        List<Pair<String, ParameterMacros>> result = super.getMacroses();
        this.addIfNotNull(result, "functionName", this.getFunctionNameMacros());
        for (Map.Entry<String, ParameterMacros> entry : this.getParametersMacros().entrySet()) {
            result.add(new Pair<String, ParameterMacros>(entry.getKey(), entry.getValue()));
        }
        return result;
    }

    @Override
    public void validate() throws APICustomizerException {
        block4: {
            block3: {
                super.validate();
                DataspaceFunctionRuleWrapper.validateParameterNotNullNotEmpty(((DataspaceFunctionRule)this.getRule()).getFunctionName(), "functionName");
                if (!(this.getRule() instanceof GenericRule)) break block3;
                this.checkMacroNotSet("functionName", this.functionNameMacros, this.functionNameMacros.isUrlQueryParameterMap());
                if (this.parametersMacros == null) break block4;
                for (Map.Entry<String, ParameterMacros> entry : this.parametersMacros.entrySet()) {
                    if (entry.getValue() == null) continue;
                    this.checkMacroNotSet("parameters." + entry.getKey(), entry.getValue(), entry.getValue().isUrlQueryParameterMap());
                }
                break block4;
            }
            this.checkIsValue("functionName", this.functionNameMacros);
            if (this.parametersMacros != null) {
                for (Map.Entry<String, ParameterMacros> entry : this.parametersMacros.entrySet()) {
                    this.checkIsValue("parameters" + entry.getKey(), entry.getValue());
                }
            }
        }
    }

    @Override
    public AbstractRuleAccessor createAccessor(Matcher matcher, HttpServletRequest request) {
        return new DataspaceFunctionRuleAccessor(this, matcher, request);
    }
}

