/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.apicustomizer.dataspace;

import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerException;
import com.streamscape.sef.network.http.server.apicustomizer.ParameterMacros;
import com.streamscape.sef.network.http.server.apicustomizer.UriBuilder;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.AbstractDataspaceRuleParametersResolver;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.DataspaceFunctionRuleWrapper;
import java.util.Map;

public abstract class DataspaceFunctionRuleParametersResolver
extends AbstractDataspaceRuleParametersResolver {
    private DataspaceFunctionRuleWrapper wrapper;

    public DataspaceFunctionRuleParametersResolver(DataspaceFunctionRuleWrapper wrapper) {
        super(wrapper);
        this.wrapper = wrapper;
    }

    @Override
    public boolean accepts() {
        return super.accepts() && (!this.wrapper.getFunctionNameMacros().isAsValue() || this.wrapper.getFunctionNameMacros().getValue().equals(this.onGetFunctionName()));
    }

    @Override
    public String resolve(ParameterMacros.ParameterMacrosType type, String name) throws APICustomizerException {
        try {
            return super.resolve(type, name);
        }
        catch (APICustomizerException exception) {
            if (UriBuilder.isThisMacros(type, name, this.wrapper.getFunctionNameMacros())) {
                return this.onGetFunctionName();
            }
            for (Map.Entry<String, ParameterMacros> entry : this.wrapper.getParametersMacros().entrySet()) {
                if (!UriBuilder.isThisMacros(type, name, entry.getValue())) continue;
                return this.onGetParameter(entry.getKey());
            }
            throw exception;
        }
    }

    protected abstract String onGetFunctionName();

    protected abstract String onGetParameter(String var1);
}

