/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.apicustomizer.dataspace;

import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerException;
import com.streamscape.sef.network.http.server.apicustomizer.ParameterMacros;
import com.streamscape.sef.network.http.server.apicustomizer.ParameterMacrosProcessor;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.AbstractDataspaceRuleAccessor;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.DataspaceFunctionRuleWrapper;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;

class DataspaceFunctionRuleAccessor
extends AbstractDataspaceRuleAccessor<DataspaceFunctionRuleWrapper> {
    public DataspaceFunctionRuleAccessor(DataspaceFunctionRuleWrapper dataspaceFunctionRuleWrapper, Matcher matcher, HttpServletRequest request) {
        super(dataspaceFunctionRuleWrapper, matcher, request);
    }

    public String getFunctionName() throws APICustomizerException {
        return this.parameterMacrosAccessor.getParameterValue(((DataspaceFunctionRuleWrapper)this.ruleWrapper).getFunctionNameMacros(), false);
    }

    public Map<String, String> getParameters() throws APICustomizerException {
        if (((DataspaceFunctionRuleWrapper)this.ruleWrapper).getParametersMacros() == null || ((DataspaceFunctionRuleWrapper)this.ruleWrapper).getParametersMacros().size() == 0) {
            return null;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Map.Entry<String, ParameterMacros> entry : ((DataspaceFunctionRuleWrapper)this.ruleWrapper).getParametersMacros().entrySet()) {
            String value = this.parameterMacrosAccessor.getParameterValue(entry.getValue(), entry.getKey(), true, false);
            if (value == null || ParameterMacrosProcessor.shouldSkip(value)) continue;
            properties.put(entry.getKey(), value);
        }
        return properties;
    }

    @Override
    protected void onCustomizeQuery(StringBuilder queryBuilder) throws APICustomizerException {
        Map<String, String> parameters = this.getParameters();
        if (parameters != null && parameters.size() > 0) {
            boolean first = true;
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                if (!first) {
                    queryBuilder.append("&");
                }
                queryBuilder.append(HTTPUtils.encodeString(entry.getKey())).append("=").append(HTTPUtils.encodeString(entry.getValue()));
                first = false;
            }
        }
        super.onCustomizeQuery(queryBuilder);
    }

    @Override
    public String customizeMethod() throws APICustomizerException {
        return "POST";
    }

    @Override
    public String customizeUri() throws APICustomizerException {
        return super.customizeUri() + "/fn/" + this.getFunctionName();
    }
}

