/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.apicustomizer.dataspace;

import com.streamscape.lib.utils.Pair;
import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerException;
import com.streamscape.sef.network.http.server.apicustomizer.AbstractRuleAccessor;
import com.streamscape.sef.network.http.server.apicustomizer.GenericRule;
import com.streamscape.sef.network.http.server.apicustomizer.ParameterMacros;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.AbstractDataspaceRuleWrapper;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.DataspaceCollectionRule;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.DataspaceCollectionRuleAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;

public class DataspaceCollectionRuleWrapper
extends AbstractDataspaceRuleWrapper<DataspaceCollectionRule> {
    private ParameterMacros collectionNameMacros;
    private ParameterMacros selectorMacros;
    private List<Pair<String, ParameterMacros>> columnsMacros;

    public DataspaceCollectionRuleWrapper(DataspaceCollectionRule dataspaceRule) throws APICustomizerException {
        super(dataspaceRule);
        DataspaceCollectionRuleWrapper.validateParameterNotNullNotEmpty(dataspaceRule.getCollectionName(), "collectionName");
        DataspaceCollectionRuleWrapper.validateParameterNotNull((Object)dataspaceRule.getOperation(), "operaiton");
        this.collectionNameMacros = this.createParameterMacrosIfNotNullNotEmpty(dataspaceRule.getCollectionName());
        this.selectorMacros = this.createParameterMacrosIfNotNullNotEmpty(dataspaceRule.getSelector());
        if (dataspaceRule.getColumns() != null && dataspaceRule.getColumns().size() > 0) {
            this.columnsMacros = new ArrayList<Pair<String, ParameterMacros>>();
            for (DataspaceCollectionRule.Column column : dataspaceRule.getColumns()) {
                this.columnsMacros.add(new Pair<String, ParameterMacros>(column.getName(), this.createParameterMacrosIfNotNullNotEmpty(column.getValue())));
            }
        }
    }

    public ParameterMacros getCollectionNameMacros() {
        return this.collectionNameMacros;
    }

    public ParameterMacros getSelectorMacros() {
        return this.selectorMacros;
    }

    public List<Pair<String, ParameterMacros>> getColumnsMacros() {
        return this.columnsMacros;
    }

    @Override
    public List<Pair<String, ParameterMacros>> getMacroses() {
        List<Pair<String, ParameterMacros>> result = super.getMacroses();
        this.addIfNotNull(result, "collectionName", this.getCollectionNameMacros());
        this.addIfNotNull(result, "where", this.getSelectorMacros());
        if (this.getColumnsMacros() != null) {
            for (Pair<String, ParameterMacros> entry : this.getColumnsMacros()) {
                this.addIfNotNull(result, (String)entry.first, (ParameterMacros)entry.second);
            }
        }
        return result;
    }

    @Override
    public void validate() throws APICustomizerException {
        block17: {
            block16: {
                super.validate();
                DataspaceCollectionRuleWrapper.validateParameterNotNullNotEmpty(((DataspaceCollectionRule)this.getRule()).getCollectionName(), "collectionName");
                DataspaceCollectionRuleWrapper.validateParameterNotNull((Object)((DataspaceCollectionRule)this.getRule()).getOperation(), "operaiton");
                switch (((DataspaceCollectionRule)this.getRule()).getOperation()) {
                    case INSERT: {
                        if (this.selectorMacros != null) {
                            throw new APICustomizerException("Invalid 'selector' parameter value. Parameter 'selector' is not allowed for INSERT into collection operation.");
                        }
                        if (this.columnsMacros != null) break;
                        throw new APICustomizerException("Invalid 'columns' parameter value. Columns should be set for INSERT into collection operation.");
                    }
                    case SELECT: {
                        if (this.columnsMacros == null) {
                            throw new APICustomizerException("Invalid 'columns' parameter value. Columns should be set for SELECT from collection operation.");
                        }
                        for (Pair<String, ParameterMacros> pair : this.columnsMacros) {
                            if (pair.second == null) continue;
                            throw new APICustomizerException("Invalid 'columns' parameter value. Column values should not be set for SELECT collection operation. Columns name: '" + (String)pair.first + "', value: '" + ((ParameterMacros)pair.second).getValue() + "'.");
                        }
                        break;
                    }
                    case UPDATE: {
                        if (this.columnsMacros != null) break;
                        throw new APICustomizerException("Invalid 'columns' parameter value. Columns should be set for UPDATE collection operation.");
                    }
                    case DELETE: {
                        if (this.columnsMacros == null) break;
                        throw new APICustomizerException("Invalid 'columns' parameter value. Columns should not be set for DELETE collection operation.");
                    }
                    default: {
                        throw new APICustomizerException("Unsupported operation " + ((DataspaceCollectionRule)this.getRule()).getOperation().toString());
                    }
                }
                if (this.columnsMacros != null) {
                    for (Pair<String, ParameterMacros> pair : this.columnsMacros) {
                        if (pair.first != null && ((String)pair.first).length() != 0) continue;
                        throw new APICustomizerException("Null or empty column name is not allowed.");
                    }
                }
                if (!(this.getRule() instanceof GenericRule)) break block16;
                if (this.collectionNameMacros != null) {
                    this.checkMacroNotSet("collectionName", this.collectionNameMacros, this.collectionNameMacros.isHttpContent() || this.collectionNameMacros.isHttpContentBytes() || this.collectionNameMacros.isUrlQueryParameterMap());
                }
                if (this.selectorMacros != null) {
                    this.checkMacroNotSet("selector", this.selectorMacros, this.selectorMacros.isHttpContent() || this.selectorMacros.isHttpContentBytes() || this.selectorMacros.isUrlQueryParameterMap());
                }
                if (this.columnsMacros == null) break block17;
                for (Pair<String, ParameterMacros> pair : this.columnsMacros) {
                    if (pair.second == null) continue;
                    this.checkMacroNotSet("column." + (String)pair.first, (ParameterMacros)pair.second, ((ParameterMacros)pair.second).isUrlQueryParameterMap());
                }
                break block17;
            }
            this.checkIsValue("collectionName", this.collectionNameMacros);
            this.checkIsValue("selector", this.selectorMacros);
            if (this.columnsMacros != null) {
                for (Pair<String, ParameterMacros> pair : this.columnsMacros) {
                    this.checkIsValue("column." + (String)pair.first, (ParameterMacros)pair.second);
                }
            }
        }
    }

    @Override
    public AbstractRuleAccessor createAccessor(Matcher matcher, HttpServletRequest request) {
        return new DataspaceCollectionRuleAccessor(this, matcher, request);
    }
}

