/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.apicustomizer.dataspace;

import com.streamscape.lib.utils.Pair;
import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerException;
import com.streamscape.sef.network.http.server.apicustomizer.ParameterMacros;
import com.streamscape.sef.network.http.server.apicustomizer.UriBuilder;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.AbstractDataspaceRuleParametersResolver;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.DataspaceCollectionRuleWrapper;

public abstract class DataspaceCollectionRuleParametersResolver
extends AbstractDataspaceRuleParametersResolver {
    private DataspaceCollectionRuleWrapper wrapper;

    public DataspaceCollectionRuleParametersResolver(DataspaceCollectionRuleWrapper wrapper) {
        super(wrapper);
        this.wrapper = wrapper;
    }

    @Override
    public boolean accepts() {
        return super.accepts() && (!this.wrapper.getCollectionNameMacros().isAsValue() || this.wrapper.getCollectionNameMacros().getValue().equals(this.onGetCollectionName(this.wrapper.getCollectionNameMacros().getParameterName())));
    }

    @Override
    public String resolve(ParameterMacros.ParameterMacrosType type, String name) throws APICustomizerException {
        try {
            return super.resolve(type, name);
        }
        catch (APICustomizerException exception) {
            if (UriBuilder.isThisMacros(type, name, this.wrapper.getCollectionNameMacros())) {
                return this.onGetCollectionName(this.wrapper.getCollectionNameMacros().getParameterName());
            }
            if (UriBuilder.isThisMacros(type, name, this.wrapper.getSelectorMacros())) {
                return this.onGetSelector(this.wrapper.getSelectorMacros().getParameterName());
            }
            if (this.wrapper.getColumnsMacros() != null) {
                for (Pair<String, ParameterMacros> entry : this.wrapper.getColumnsMacros()) {
                    if (!UriBuilder.isThisMacros(type, name, (ParameterMacros)entry.second)) continue;
                    return this.onGetColumn((String)entry.first);
                }
            }
            throw exception;
        }
    }

    protected abstract String onGetCollectionName(String var1);

    protected abstract String onGetSelector(String var1);

    protected abstract String onGetColumn(String var1);
}

