/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.apicustomizer.dataspace;

import com.streamscape.lib.utils.Pair;
import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerException;
import com.streamscape.sef.network.http.server.apicustomizer.ParameterMacros;
import com.streamscape.sef.network.http.server.apicustomizer.ParameterMacrosProcessor;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.AbstractDataspaceRuleAccessor;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.DataspaceCollectionRule;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.DataspaceCollectionRuleWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;

class DataspaceCollectionRuleAccessor
extends AbstractDataspaceRuleAccessor<DataspaceCollectionRuleWrapper> {
    public DataspaceCollectionRuleAccessor(DataspaceCollectionRuleWrapper dataspaceRuleWrapper, Matcher matcher, HttpServletRequest request) {
        super(dataspaceRuleWrapper, matcher, request);
    }

    public String getCollectionName() throws APICustomizerException {
        return this.parameterMacrosAccessor.getParameterValue(((DataspaceCollectionRuleWrapper)this.ruleWrapper).getCollectionNameMacros(), false);
    }

    public String getSelector() throws APICustomizerException {
        String value = this.parameterMacrosAccessor.getParameterValue(((DataspaceCollectionRuleWrapper)this.ruleWrapper).getSelectorMacros(), "where", true, false);
        if (ParameterMacrosProcessor.shouldSkip(value)) {
            value = null;
        }
        return value;
    }

    public List<Pair<String, String>> getColumns() throws APICustomizerException {
        ArrayList<Pair<String, String>> columns = new ArrayList<Pair<String, String>>();
        if (((DataspaceCollectionRuleWrapper)this.ruleWrapper).getColumnsMacros() == null || ((DataspaceCollectionRuleWrapper)this.ruleWrapper).getColumnsMacros().size() == 0) {
            return columns;
        }
        for (Pair<String, ParameterMacros> pair : ((DataspaceCollectionRuleWrapper)this.ruleWrapper).getColumnsMacros()) {
            String value = this.parameterMacrosAccessor.getParameterValue((ParameterMacros)pair.second, (String)pair.first, true, ((DataspaceCollectionRule)((DataspaceCollectionRuleWrapper)this.ruleWrapper).getRule()).getOperation() != DataspaceCollectionRule.DataspaceCollectionOperation.INSERT && ((DataspaceCollectionRule)((DataspaceCollectionRuleWrapper)this.ruleWrapper).getRule()).getOperation() != DataspaceCollectionRule.DataspaceCollectionOperation.UPDATE);
            if (ParameterMacrosProcessor.shouldSkip(value)) continue;
            columns.add(new Pair<String, String>((String)pair.first, value));
        }
        return columns;
    }

    @Override
    protected void onCustomizeQuery(StringBuilder queryBuilder) throws APICustomizerException {
        super.onCustomizeQuery(queryBuilder);
        this.appendIfNotNullNotEmpty(queryBuilder, "where", this.getSelector());
        for (Pair<String, String> column : this.getColumns()) {
            switch (((DataspaceCollectionRule)((DataspaceCollectionRuleWrapper)this.ruleWrapper).getRule()).getOperation()) {
                case INSERT: 
                case UPDATE: {
                    if (column.second != null && column.second != "") break;
                    throw new APICustomizerException("Invalid INSERT/UPDATE operation. Value not set for column '" + (String)column.second + "'.");
                }
                case SELECT: {
                    if (column.second == null || ((String)column.second).length() <= 0) break;
                    throw new APICustomizerException("Invalid SELECT operation. Value is set for column '" + (String)column.second + "'.");
                }
            }
            this.append(queryBuilder, (String)column.first, (String)column.second);
        }
    }

    @Override
    public String customizeMethod() throws APICustomizerException {
        switch (((DataspaceCollectionRule)((DataspaceCollectionRuleWrapper)this.ruleWrapper).getRule()).getOperation()) {
            case DELETE: {
                return "DELETE";
            }
            case INSERT: {
                return "POST";
            }
            case SELECT: {
                return "GET";
            }
            case UPDATE: {
                return "PUT";
            }
        }
        throw new APICustomizerException("Unknown operation " + String.valueOf((Object)((DataspaceCollectionRule)((DataspaceCollectionRuleWrapper)this.ruleWrapper).getRule()).getOperation()));
    }

    @Override
    public String customizeUri() throws APICustomizerException {
        return super.customizeUri() + "/collection/" + this.getCollectionName();
    }
}

