/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.apicustomizer.dataspace;

import com.streamscape.lib.utils.Pair;
import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerException;
import com.streamscape.sef.network.http.server.apicustomizer.AbstractRuleWrapper;
import com.streamscape.sef.network.http.server.apicustomizer.GenericRule;
import com.streamscape.sef.network.http.server.apicustomizer.ParameterMacros;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.AbstractDataspaceRule;
import java.util.List;

public abstract class AbstractDataspaceRuleWrapper<T extends AbstractDataspaceRule>
extends AbstractRuleWrapper<T> {
    private ParameterMacros dataspaceNameMacros;
    private ParameterMacros norowsetMacros;
    private ParameterMacros norowsMacros;
    private ParameterMacros transferBufferSizeMacros;
    private ParameterMacros queryTimeoutMacros;

    public AbstractDataspaceRuleWrapper(T dataspaceRule) throws APICustomizerException {
        super(dataspaceRule);
        AbstractDataspaceRuleWrapper.validateParameterNotNullNotEmpty(((AbstractDataspaceRule)dataspaceRule).getDataspaceName(), "dataspaceName");
        this.dataspaceNameMacros = this.createParameterMacrosIfNotNullNotEmpty(((AbstractDataspaceRule)dataspaceRule).getDataspaceName());
        this.norowsetMacros = this.createParameterMacrosIfNotNullNotEmpty(((AbstractDataspaceRule)dataspaceRule).getNorowset());
        this.norowsMacros = this.createParameterMacrosIfNotNullNotEmpty(((AbstractDataspaceRule)dataspaceRule).getNorows());
        this.transferBufferSizeMacros = this.createParameterMacrosIfNotNullNotEmpty(((AbstractDataspaceRule)dataspaceRule).getTransferBufferSize());
        this.queryTimeoutMacros = this.createParameterMacrosIfNotNullNotEmpty(((AbstractDataspaceRule)dataspaceRule).getQueryTimeout());
    }

    public ParameterMacros getDataspaceNameMacros() {
        return this.dataspaceNameMacros;
    }

    public ParameterMacros getNorowsetMacros() {
        return this.norowsetMacros;
    }

    public ParameterMacros getNorowsMacros() {
        return this.norowsMacros;
    }

    public ParameterMacros getTransferBufferSizeMacros() {
        return this.transferBufferSizeMacros;
    }

    public ParameterMacros getQueryTimeoutMacros() {
        return this.queryTimeoutMacros;
    }

    @Override
    public List<Pair<String, ParameterMacros>> getMacroses() {
        List<Pair<String, ParameterMacros>> result = super.getMacroses();
        this.addIfNotNull(result, "dataspaceName", this.getDataspaceNameMacros());
        this.addIfNotNull(result, "norowset", this.getNorowsetMacros());
        this.addIfNotNull(result, "norows", this.getNorowsMacros());
        this.addIfNotNull(result, "transferBufferSize", this.getTransferBufferSizeMacros());
        this.addIfNotNull(result, "queryTimeout", this.getQueryTimeoutMacros());
        return result;
    }

    @Override
    public void validate() throws APICustomizerException {
        super.validate();
        AbstractDataspaceRuleWrapper.validateParameterNotNullNotEmpty(((AbstractDataspaceRule)this.getRule()).getDataspaceName(), "dataspaceName");
        if (this.getRule() instanceof GenericRule) {
            this.checkMacroNotSet("dataspaceName", this.dataspaceNameMacros, this.dataspaceNameMacros.isHttpContent() || this.dataspaceNameMacros.isHttpContentBytes() || this.dataspaceNameMacros.isUrlQueryParameterMap());
            if (this.norowsetMacros != null) {
                this.checkMacroNotSet("norowset", this.norowsetMacros, this.norowsetMacros.isHttpContent() || this.norowsetMacros.isHttpContentBytes() || this.norowsetMacros.isUrlQueryParameterMap());
            }
            if (this.norowsMacros != null) {
                this.checkMacroNotSet("norows", this.norowsetMacros, this.norowsMacros.isHttpContent() || this.norowsMacros.isHttpContentBytes() || this.norowsMacros.isUrlQueryParameterMap());
            }
            if (this.transferBufferSizeMacros != null) {
                this.checkMacroNotSet("transferBufferSize", this.transferBufferSizeMacros, this.transferBufferSizeMacros.isHttpContent() || this.transferBufferSizeMacros.isHttpContentBytes() || this.transferBufferSizeMacros.isUrlQueryParameterMap());
            }
            if (this.queryTimeoutMacros != null) {
                this.checkMacroNotSet("queryTimeout", this.queryTimeoutMacros, this.queryTimeoutMacros.isHttpContent() || this.queryTimeoutMacros.isHttpContentBytes() || this.queryTimeoutMacros.isUrlQueryParameterMap());
            }
        } else {
            this.checkIsValue("dataspaceName", this.dataspaceNameMacros);
            this.checkIsValue("norowset", this.norowsetMacros);
            this.checkIsValue("norows", this.norowsMacros);
        }
    }
}

