/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.apicustomizer.any;

import com.streamscape.lib.utils.Pair;
import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerException;
import com.streamscape.sef.network.http.server.apicustomizer.AbstractRuleAccessor;
import com.streamscape.sef.network.http.server.apicustomizer.AbstractRuleWrapper;
import com.streamscape.sef.network.http.server.apicustomizer.ParameterMacros;
import com.streamscape.sef.network.http.server.apicustomizer.UriMacros;
import com.streamscape.sef.network.http.server.apicustomizer.any.AnyRule;
import com.streamscape.sef.network.http.server.apicustomizer.any.AnyRuleAccessor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;

public class AnyRuleWrapper
extends AbstractRuleWrapper<AnyRule> {
    private UriMacros customizedUriMacros;
    private Map<String, ParameterMacros> cookiesMacros = new HashMap<String, ParameterMacros>();

    public AnyRuleWrapper(AnyRule anyRule) throws APICustomizerException {
        super(anyRule);
        AnyRuleWrapper.validateParameterNotNullNotEmpty(anyRule.getCustomizedUri(), "customizedUri");
        AnyRuleWrapper.validateParameterNotNullNotEmpty(anyRule.getCustomizedMethod(), "customizedMethod");
        this.customizedUriMacros = new UriMacros(anyRule.getCustomizedUri(), this.getUriMatcher());
        if (anyRule.getCookies() != null && anyRule.getCookies().size() > 0) {
            this.cookiesMacros = new HashMap<String, ParameterMacros>();
            for (Map.Entry<Object, Object> entry : anyRule.getCookies().entrySet()) {
                this.cookiesMacros.put((String)entry.getKey(), this.createParameterMacrosIfNotNull((String)entry.getValue()));
            }
        }
    }

    @Override
    public void validate() throws APICustomizerException {
        super.validate();
        AnyRuleWrapper.validateParameterNotNullNotEmpty(((AnyRule)this.getRule()).getCustomizedUri(), "customizedUrl");
        AnyRuleWrapper.validateParameterNotNullNotEmpty(((AnyRule)this.getRule()).getCustomizedMethod(), "customizedMethod");
        if (this.cookiesMacros != null) {
            for (Map.Entry<String, ParameterMacros> entry : this.cookiesMacros.entrySet()) {
                if (entry.getValue() == null) continue;
                this.checkMacroNotSet("cookies." + entry.getKey(), entry.getValue(), entry.getValue().isUrlQueryParameterMap());
            }
        }
    }

    @Override
    public AbstractRuleAccessor createAccessor(Matcher matcher, HttpServletRequest request) {
        return new AnyRuleAccessor(this, matcher, request);
    }

    public UriMacros getCustomizedUriMacros() {
        return this.customizedUriMacros;
    }

    public Map<String, ParameterMacros> getCookiesMacros() {
        return this.cookiesMacros;
    }

    @Override
    public List<Pair<String, ParameterMacros>> getMacroses() {
        List<Pair<String, ParameterMacros>> result = super.getMacroses();
        for (Map.Entry<String, ParameterMacros> entry : this.getCookiesMacros().entrySet()) {
            result.add(new Pair<String, ParameterMacros>(entry.getKey(), entry.getValue()));
        }
        return result;
    }
}

