/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.apicustomizer.any;

import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerException;
import com.streamscape.sef.network.http.server.apicustomizer.AbstractRuleAccessor;
import com.streamscape.sef.network.http.server.apicustomizer.ParameterMacros;
import com.streamscape.sef.network.http.server.apicustomizer.ParameterMacrosProcessor;
import com.streamscape.sef.network.http.server.apicustomizer.UriMacrosProcessor;
import com.streamscape.sef.network.http.server.apicustomizer.any.AnyRule;
import com.streamscape.sef.network.http.server.apicustomizer.any.AnyRuleWrapper;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;

public class AnyRuleAccessor
extends AbstractRuleAccessor<AnyRuleWrapper> {
    private final UriMacrosProcessor uriMacrosProcessor;

    public AnyRuleAccessor(AnyRuleWrapper anyRuleWrapper, Matcher matcher, HttpServletRequest request) {
        super(anyRuleWrapper, matcher, request);
        this.uriMacrosProcessor = new UriMacrosProcessor(request, matcher);
    }

    public Map<String, String> getCookies() throws APICustomizerException {
        if (((AnyRuleWrapper)this.ruleWrapper).getCookiesMacros() == null || ((AnyRuleWrapper)this.ruleWrapper).getCookiesMacros().size() == 0) {
            return null;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Map.Entry<String, ParameterMacros> entry : ((AnyRuleWrapper)this.ruleWrapper).getCookiesMacros().entrySet()) {
            String value = this.parameterMacrosAccessor.getParameterValue(entry.getValue(), entry.getKey(), true, false);
            if (value == null || ParameterMacrosProcessor.shouldSkip(value)) continue;
            properties.put(entry.getKey(), value);
        }
        return properties;
    }

    @Override
    public String customizeMethod() throws APICustomizerException {
        return ((AnyRule)((AnyRuleWrapper)this.ruleWrapper).getRule()).getCustomizedMethod();
    }

    @Override
    public String customizeUri() throws APICustomizerException {
        return this.uriMacrosProcessor.getUriValue(((AnyRuleWrapper)this.ruleWrapper).getCustomizedUriMacros());
    }

    @Override
    protected void onCustomizeQuery(StringBuilder queryBuilder) throws APICustomizerException {
        AnyRule rule = (AnyRule)((AnyRuleWrapper)this.ruleWrapper).getRule();
        if (rule.getSearchString() != null && rule.getSearchString().length() > 0) {
            queryBuilder.append("?").append(rule.getSearchString());
        }
        if (rule.getFragments() != null && rule.getFragments().length() > 0) {
            queryBuilder.append("#").append(rule.getFragments());
        }
    }
}

