/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.apicustomizer;

import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UriMatcher {
    private Pattern pattern = null;
    private String matchedUrl = null;
    private List<String> parameters;
    private List<String> uriParts = new ArrayList<String>();
    private static Pattern PARAMETER_NAME_PATTERN = Pattern.compile("^\\w+$");
    private static Pattern PARAMETER_VALUE_PATTERN = Pattern.compile("([\\w\\.\\-~:@!$&'()*+,;=]+)");
    private static Pattern PARAMETER_ANY_VALUE_OPTIONAL_PATTERN = Pattern.compile("(.*)");
    private static Pattern PARAMETER_ANY_VALUE_PATTERN = Pattern.compile("(.+)");

    public UriMatcher(String uri) throws APICustomizerException {
        this.init(uri);
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public Matcher matcher(String uri) {
        if (this.pattern == null) {
            return null;
        }
        return this.pattern.matcher(uri);
    }

    public boolean hasParameters() {
        return this.parameters != null && this.parameters.size() > 0;
    }

    public int parametersCount() {
        return this.parameters == null ? 0 : this.parameters.size();
    }

    public boolean existsParameter(String name) {
        if (this.parameters == null || this.parameters.size() == 0) {
            return false;
        }
        return this.parameters.contains(name);
    }

    public int getParameterIndex(String name) {
        int i;
        if (this.parameters == null || this.parameters.size() == 0) {
            return -1;
        }
        for (i = 0; i < this.parameters.size() && !this.parameters.get(i).equals(name); ++i) {
        }
        return i < this.parameters.size() ? i : -1;
    }

    public String getParameterValue(String name, Matcher matcher) {
        int index = this.getParameterIndex(name);
        if (index < 0 || index > matcher.groupCount()) {
            return null;
        }
        return matcher.group(index + 1);
    }

    public String getParameterValue(int index, Matcher matcher) {
        if (index < 0 || index > matcher.groupCount()) {
            return null;
        }
        return matcher.group(index + 1);
    }

    public List<String> getUriParts() {
        return new ArrayList<String>(this.uriParts);
    }

    protected void init(String uri) throws APICustomizerException {
        if (uri == null) {
            return;
        }
        uri = UriMatcher.normalizeUri(uri);
        int pos = 0;
        int endPos = 0;
        StringBuilder patternBuilder = new StringBuilder();
        patternBuilder.append("^");
        this.matchedUrl = "";
        this.uriParts = new ArrayList<String>();
        while ((pos = uri.indexOf("{", pos)) != -1) {
            patternBuilder.append(Pattern.quote(uri.substring(endPos, pos)));
            String uriPart = uri.substring(endPos, pos);
            this.matchedUrl = this.matchedUrl + uriPart;
            this.uriParts.add(uriPart);
            endPos = uri.indexOf("}", pos);
            if (endPos == -1) {
                throw new APICustomizerException("URI parsing failed: expected '}' after '" + uri.substring(0, pos) + "' for URI '" + uri + "'.");
            }
            String parameterName = uri.substring(pos + 1, endPos);
            if (parameterName.equals("*") || parameterName.equals("+")) {
                if (endPos + 1 != uri.length()) {
                    throw new APICustomizerException("URI parsing failed: parameter {*} or {+} can be placed only at the last segment of URI.");
                }
                if (parameterName.equals("*")) {
                    patternBuilder.append(PARAMETER_ANY_VALUE_OPTIONAL_PATTERN);
                } else {
                    patternBuilder.append(PARAMETER_ANY_VALUE_PATTERN);
                }
                this.matchedUrl = this.matchedUrl + "_1SOME2_3VALUE4_/_1SOME2_3VALUE4_";
            } else {
                Matcher matcher;
                int colonPos = parameterName.indexOf(":");
                Pattern valuePattern = PARAMETER_VALUE_PATTERN;
                if (colonPos != -1) {
                    Object valueRegexp = parameterName.substring(colonPos + 1);
                    if (!((String)valueRegexp).startsWith("(") && !((String)valueRegexp).endsWith(")")) {
                        valueRegexp = "(" + (String)valueRegexp + ")";
                    }
                    try {
                        valuePattern = Pattern.compile((String)valueRegexp);
                    }
                    catch (Exception exception) {
                        throw new APICustomizerException("URI parsing failed: invalid regexp '" + (String)valueRegexp + "' for parameter '" + parameterName + "'. Cause: " + exception.getMessage());
                    }
                    parameterName = parameterName.substring(0, colonPos);
                }
                if (!(matcher = PARAMETER_NAME_PATTERN.matcher(parameterName)).matches()) {
                    throw new APICustomizerException("URI parsing failed: parameter name '" + parameterName + "' doesn't match pattern '" + PARAMETER_NAME_PATTERN.pattern() + "'.");
                }
                patternBuilder.append(valuePattern);
                this.matchedUrl = this.matchedUrl + "_1SOME2_3VALUE4_";
            }
            this.uriParts.add(uri.substring(pos, endPos + 1));
            if (this.parameters == null) {
                this.parameters = new ArrayList<String>();
            }
            if (this.parameters.contains(parameterName)) {
                throw new APICustomizerException("URI parsing failed: parameter names should be unique in one uri, repeated name: '" + parameterName + "'.");
            }
            this.parameters.add(parameterName);
            pos = ++endPos;
        }
        if (endPos == 0) {
            patternBuilder.append(uri);
            this.matchedUrl = this.matchedUrl + uri;
            this.uriParts.add(uri);
        } else if (endPos < uri.length()) {
            patternBuilder.append(Pattern.quote(uri.substring(endPos)));
            this.matchedUrl = this.matchedUrl + uri.substring(endPos);
            this.uriParts.add(uri.substring(endPos));
        }
        patternBuilder.append("$");
        this.pattern = Pattern.compile(patternBuilder.toString());
    }

    String getMatchedUrl() {
        return this.matchedUrl;
    }

    public static String normalizeUriWithLastSlashRemove(String uri) {
        if ((uri = UriMatcher.normalizeUri(uri)) != null && uri.length() > 1 && uri.endsWith("/")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        return uri;
    }

    public static String normalizeUriWithAddLastSlash(String uri) {
        if ((uri = UriMatcher.normalizeUri((String)uri)) != null && !((String)uri).endsWith("/")) {
            uri = (String)uri + "/";
        }
        return uri;
    }

    public static String normalizeUri(String uri) {
        if (uri != null) {
            uri = uri.trim();
            uri = uri.replaceAll("/+", "/");
            uri = uri.trim();
        }
        return uri;
    }
}

