/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.apicustomizer;

import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerException;
import com.streamscape.sef.network.http.server.apicustomizer.ParameterMacros;
import com.streamscape.sef.network.http.server.apicustomizer.UriMatcher;
import java.util.ArrayList;
import java.util.List;

public class UriMacros {
    private List<ParameterMacros> macroses = new ArrayList<ParameterMacros>();
    private boolean endsWithSlash;

    public UriMacros(String uri, UriMatcher uriMatcher) throws APICustomizerException {
        this.endsWithSlash = uri.endsWith("/");
        String normalizedUri = UriMatcher.normalizeUriWithLastSlashRemove(uri);
        if (normalizedUri.startsWith("/")) {
            normalizedUri = normalizedUri.substring(1);
        }
        for (String uriPart : normalizedUri.split("/")) {
            this.macroses.add(new ParameterMacros(uriPart, uriMatcher));
        }
    }

    public List<ParameterMacros> getMacroses() {
        return this.macroses;
    }

    public boolean isEndsWithSlash() {
        return this.endsWithSlash;
    }
}

