/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.apicustomizer;

import com.streamscape.lib.utils.Pair;
import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerException;
import com.streamscape.sef.network.http.server.apicustomizer.ParameterMacros;
import com.streamscape.sef.network.http.server.apicustomizer.UriMatcher;
import java.util.List;

public class UriBuilder {
    private UriMatcher matcher;

    public UriBuilder(UriMatcher matcher) {
        this.matcher = matcher;
    }

    public String build(UriParameterResolver resolver) throws APICustomizerException {
        StringBuilder builder = new StringBuilder();
        for (String part : this.matcher.getUriParts()) {
            if (part.startsWith("{") && part.endsWith("}")) {
                builder.append(resolver.resolve(ParameterMacros.ParameterMacrosType.URI_FRAGMENT, part.substring(1, part.length() - 1)));
                continue;
            }
            builder.append(part);
        }
        return builder.toString();
    }

    public static boolean isThisMacros(ParameterMacros.ParameterMacrosType type, String name, ParameterMacros macros) {
        return macros != null && macros.getType() == type && (macros.getParameterName() != null && name != null && macros.getParameterName().equals(name) || macros.getType() == ParameterMacros.ParameterMacrosType.HTTP_CONTENT || macros.getType() == ParameterMacros.ParameterMacrosType.HTTP_CONTENT_BYTES);
    }

    public static interface UriParameterResolver {
        public boolean accepts();

        public String resolve(ParameterMacros.ParameterMacrosType var1, String var2) throws APICustomizerException;

        public List<Pair<String, ParameterMacros>> getMacroses();
    }
}

