/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.apicustomizer;

import com.streamscape.sef.network.http.acceptor.HTTPAcceptorConfiguration;
import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerException;
import com.streamscape.sef.network.http.server.apicustomizer.ParameterMacros;
import com.streamscape.sef.network.http.server.servlet.RestServletUtils;
import com.streamscape.sef.network.http.server.utils.CustomizedDiskFileItemFactory;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import com.streamscape.sef.network.http.server.utils.MultipartFormDataHelper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;

public class ParameterMacrosProcessor {
    public static String SKIP_THIS_VALUE = "__SKIP_THIS_VALUE__";
    private HttpServletRequest request;
    private Matcher matcher;

    public ParameterMacrosProcessor(HttpServletRequest request, Matcher matcher) {
        this.request = request;
        this.matcher = matcher;
    }

    public String getParameterValue(ParameterMacros macros, boolean optional) throws APICustomizerException {
        return this.getParameterValue(macros, null, optional, true);
    }

    public String getParameterValue(ParameterMacros macros, String newParameterName, boolean optional, boolean withReadOfHttpContent) throws APICustomizerException {
        if (macros == null) {
            return null;
        }
        if (macros.isAsValue()) {
            return macros.getValue();
        }
        if (macros.isUriFragment()) {
            return this.matcher.group(macros.getUriFragmentIndex() + 1);
        }
        if (macros.isHttpHeader()) {
            String headerValue = this.request.getHeader(macros.getHttpHeaderName());
            if (headerValue == null && !optional) {
                throw new APICustomizerException("Failed to get value of parameter '" + macros.getParameter() + "', header '" + macros.getHttpHeaderName() + "' is missing.");
            }
            return headerValue;
        }
        if (macros.isUrlQueryParameter()) {
            String value = this.request.getParameter(macros.getUrlQueryParameterName());
            if (value == null && !optional) {
                throw new APICustomizerException("Failed to get value of parameter '" + macros.getParameter() + "' from query, query parameter '" + macros.getUrlQueryParameterName() + "' is missing.");
            }
            return value;
        }
        if (macros.isHttpContent()) {
            if (withReadOfHttpContent) {
                try {
                    String requestString = HTTPUtils.readPostRequestAsString(this.request);
                    if (requestString == null && !optional) {
                        throw new APICustomizerException("Failed to get value of parameter '" + macros.getParameter() + "' from http content, there is no content.");
                    }
                    return requestString;
                }
                catch (IOException exception) {
                    throw new APICustomizerException("Failed to get value of parameter '" + macros.getParameter() + "' from http content, cause: " + exception.toString());
                }
            }
            return macros.getParameter();
        }
        if (macros.isHttpContentBytes()) {
            return macros.getParameter();
        }
        if (macros.isHttpMultipartFilename()) {
            return this.getMultipartPart(macros, true, false).getName();
        }
        if (macros.isHttpMultipartData()) {
            FileItem part = this.getMultipartPart(macros, false, false);
            ((CustomizedDiskFileItemFactory.CustomizedDiskFileItem)part).setNewFieldName(newParameterName);
            String contentType = part.getContentType();
            String charset = RestServletUtils.getCharset(contentType);
            if (part.isFormField() && !RestServletUtils.isContentType(contentType, "application/octet-stream")) {
                byte[] data = part.get();
                this.getMultipartPart(macros, false, true);
                MultipartFormDataHelper.removeTemporaryMultiPartFile(part);
                if (data != null) {
                    try {
                        return new String(data, charset != null && Charset.isSupported(charset) ? charset : StandardCharsets.UTF_8.name());
                    }
                    catch (UnsupportedEncodingException e) {
                        return new String(data);
                    }
                }
                return "";
            }
            return SKIP_THIS_VALUE;
        }
        if (macros.isUrlQueryParameterMap()) {
            return this.request.getQueryString();
        }
        throw new APICustomizerException("Unsupported macros: " + macros.getParameter());
    }

    private FileItem getMultipartPart(ParameterMacros macros, boolean onlyFile, boolean andRemove) throws APICustomizerException {
        List<FileItem> parts;
        try {
            parts = MultipartFormDataHelper.getOrParseMultiParts(this.request, (HTTPAcceptorConfiguration)this.request.getAttribute(HTTPAcceptorConfiguration.ATTRIBUTE), -1);
        }
        catch (IOException exception) {
            throw new APICustomizerException("Failed to parse http multipart data for parameter '" + macros.getParameter() + "', cause: " + exception.toString());
        }
        if (parts == null) {
            throw new APICustomizerException("Failed to get value of parameter '" + macros.getParameter() + "', there is no multipart/form-data content.");
        }
        for (FileItem part : parts) {
            if ((part.getFieldName() == null || !part.getFieldName().equals(macros.getHttpMultipartParameterName())) && (!(part instanceof CustomizedDiskFileItemFactory.CustomizedDiskFileItem) || ((CustomizedDiskFileItemFactory.CustomizedDiskFileItem)part).getOldFieldName() == null || !((CustomizedDiskFileItemFactory.CustomizedDiskFileItem)part).getOldFieldName().equals(macros.getHttpMultipartParameterName())) || onlyFile && part.isFormField()) continue;
            if (andRemove) {
                parts.remove(part);
            }
            return part;
        }
        throw new APICustomizerException("Failed to get value of parameter '" + macros.getParameter() + "', there is no such part in multipart/form-data content.");
    }

    public static boolean shouldSkip(String value) {
        return value == SKIP_THIS_VALUE;
    }
}

