/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.apicustomizer;

import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerException;
import com.streamscape.sef.network.http.server.apicustomizer.UriMatcher;
import java.util.Objects;

public class ParameterMacros {
    public static final String URL_QUERY_PARAMETER = "url_query{&";
    public static final String URL_QUERY_PARAMETER_MAP = "url_query{parameter_map}";
    public static final String URI_FRAGMENT = "uri{";
    public static final String HTTP_CONTENT = "http{content}";
    public static final String HTTP_CONTENT_BYTES = "http{content-bytes}";
    public static final String HEADER_PARAMETER = "http{header=";
    public static final String HTTP_MULTIPART_PARAMETER = "http{multipart[";
    public static final String HTTP_MULTIPART_FILENAME_PARAMETER = "]-filename}";
    public static final String HTTP_MULTIPART_DATA_PARAMETER = "]-data}";
    private String parameter;
    private ParameterMacrosType parameterType;
    private String parameterName;
    private int uriFragmentIndex = -1;
    private String value = null;

    public ParameterMacros(String parameter, UriMatcher uriMatcher) throws APICustomizerException {
        this.parameter = parameter;
        if (parameter == null) {
            return;
        }
        if (parameter.startsWith(URL_QUERY_PARAMETER) && parameter.endsWith("}")) {
            this.parameterType = ParameterMacrosType.URL_QUERY_PARAMETER;
            this.parameterName = parameter.substring(URL_QUERY_PARAMETER.length(), parameter.length() - 1);
        } else if (parameter.equalsIgnoreCase(URL_QUERY_PARAMETER_MAP)) {
            this.parameterType = ParameterMacrosType.URL_QUERY_PARAMETER_MAP;
        } else if (parameter.startsWith(URI_FRAGMENT) && parameter.endsWith("}")) {
            this.parameterType = ParameterMacrosType.URI_FRAGMENT;
            this.parameterName = parameter.substring(URI_FRAGMENT.length(), parameter.length() - 1);
            if (!uriMatcher.existsParameter(this.parameterName)) {
                throw new APICustomizerException("Fragment '" + this.parameterName + "' not present in URI.");
            }
            this.uriFragmentIndex = uriMatcher.getParameterIndex(this.parameterName);
        } else if (parameter.equalsIgnoreCase(HTTP_CONTENT)) {
            this.parameterType = ParameterMacrosType.HTTP_CONTENT;
        } else if (parameter.equalsIgnoreCase(HTTP_CONTENT_BYTES)) {
            this.parameterType = ParameterMacrosType.HTTP_CONTENT_BYTES;
        } else if (parameter.startsWith(HEADER_PARAMETER) && parameter.endsWith("}")) {
            this.parameterType = ParameterMacrosType.HTTP_HEADER_PARAMETER;
            this.parameterName = parameter.substring(HEADER_PARAMETER.length(), parameter.length() - 1);
        } else if (parameter.startsWith(HTTP_MULTIPART_PARAMETER) && parameter.endsWith(HTTP_MULTIPART_FILENAME_PARAMETER)) {
            this.parameterType = ParameterMacrosType.HTTP_MULTIPART_FILENAME;
            this.parameterName = parameter.substring(HTTP_MULTIPART_PARAMETER.length(), parameter.length() - HTTP_MULTIPART_FILENAME_PARAMETER.length());
        } else if (parameter.startsWith(HTTP_MULTIPART_PARAMETER) && parameter.endsWith(HTTP_MULTIPART_DATA_PARAMETER)) {
            this.parameterType = ParameterMacrosType.HTTP_MULTIPART_DATA;
            this.parameterName = parameter.substring(HTTP_MULTIPART_PARAMETER.length(), parameter.length() - HTTP_MULTIPART_DATA_PARAMETER.length());
        } else {
            this.parameterType = ParameterMacrosType.VALUE;
            this.value = parameter;
        }
    }

    public String getParameter() {
        return this.parameter;
    }

    public boolean isUrlQueryParameter() {
        return this.parameterType == ParameterMacrosType.URL_QUERY_PARAMETER;
    }

    public String getUrlQueryParameterName() {
        return this.parameterName;
    }

    public boolean isUrlQueryParameterMap() {
        return this.parameterType == ParameterMacrosType.URL_QUERY_PARAMETER_MAP;
    }

    public boolean isUriFragment() {
        return this.parameterType == ParameterMacrosType.URI_FRAGMENT;
    }

    public String getUriFragmentName() {
        return this.parameterName;
    }

    public int getUriFragmentIndex() {
        return this.uriFragmentIndex;
    }

    public boolean isHttpContent() {
        return this.parameterType == ParameterMacrosType.HTTP_CONTENT;
    }

    public boolean isHttpContentBytes() {
        return this.parameterType == ParameterMacrosType.HTTP_CONTENT_BYTES;
    }

    public boolean isHttpHeader() {
        return this.parameterType == ParameterMacrosType.HTTP_HEADER_PARAMETER;
    }

    public String getHttpHeaderName() {
        return this.parameterName;
    }

    public boolean isHttpMultipart() {
        return this.parameterType == ParameterMacrosType.HTTP_MULTIPART_DATA || this.parameterType == ParameterMacrosType.HTTP_MULTIPART_FILENAME;
    }

    public boolean isHttpMultipartFilename() {
        return this.parameterType == ParameterMacrosType.HTTP_MULTIPART_FILENAME;
    }

    public boolean isHttpMultipartData() {
        return this.parameterType == ParameterMacrosType.HTTP_MULTIPART_DATA;
    }

    public String getHttpMultipartParameterName() {
        return this.parameterName;
    }

    public boolean isAsValue() {
        return this.parameterType == ParameterMacrosType.VALUE;
    }

    public String getValue() {
        return this.value;
    }

    public ParameterMacrosType getType() {
        return this.parameterType;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public boolean acceptsValue(String value) {
        return this.parameterType != ParameterMacrosType.VALUE || Objects.equals(this.value, value);
    }

    public static enum ParameterMacrosType {
        URL_QUERY_PARAMETER,
        URL_QUERY_PARAMETER_MAP,
        URI_FRAGMENT,
        HTTP_CONTENT,
        HTTP_CONTENT_BYTES,
        HTTP_HEADER_PARAMETER,
        HTTP_MULTIPART_FILENAME,
        HTTP_MULTIPART_DATA,
        VALUE;

    }
}

