/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.apicustomizer;

import com.streamscape.sef.network.http.server.utils.HTTPUtils;

public class HintsMatcher {
    public static final int REQUEST_FORMAT_JSON_INDEX = 0;
    public static final int RESPONSE_FORMAT_JSON_INDEX = 1;
    public static final int REQUEST_FORMAT_XML_INDEX = 2;
    public static final int RESPONSE_FORMAT_XML_INDEX = 3;
    private String[] hints = new String[4];

    public HintsMatcher(String requestHintJSON, String responseHintJSON, String requestHintXML, String responseHintXML) {
        if (requestHintJSON != null && requestHintJSON.length() > 0) {
            this.hints[0] = requestHintJSON;
        }
        if (responseHintJSON != null && responseHintJSON.length() > 0) {
            this.hints[1] = responseHintJSON;
        }
        if (requestHintXML != null && requestHintXML.length() > 0) {
            this.hints[2] = requestHintXML;
        }
        if (responseHintXML != null && responseHintXML.length() > 0) {
            this.hints[3] = responseHintXML;
        }
    }

    public String matchData(String data, boolean[] results) throws Exception {
        if (data == null) {
            return null;
        }
        int beginIndex = 0;
        int endIndex = data.length();
        boolean changed = false;
        do {
            changed = false;
            for (int i = 0; i < this.hints.length; ++i) {
                while (beginIndex < endIndex && data.charAt(beginIndex) == ' ') {
                    ++beginIndex;
                }
                while (endIndex > beginIndex && data.charAt(endIndex - 1) == ' ') {
                    --endIndex;
                }
                String hint = this.hints[i];
                if (hint != null && hint.length() > 0 && endIndex - beginIndex >= hint.length()) {
                    if (data.substring(beginIndex, beginIndex + hint.length()).equals(hint)) {
                        if (results[i]) {
                            throw new Exception("Hint '" + hint + "' occured more than onece.");
                        }
                        results[i] = true;
                        beginIndex += hint.length();
                        changed = true;
                    } else if (data.substring(endIndex - hint.length(), endIndex).equals(hint)) {
                        if (results[i]) {
                            throw new Exception("Hint '" + hint + "' occured more than once.");
                        }
                        results[i] = true;
                        endIndex -= hint.length();
                        changed = true;
                    }
                }
                if (hint != null) {
                    hint = HTTPUtils.encodeString(hint);
                }
                if (hint == null || hint.length() <= 0 || endIndex - beginIndex < hint.length()) continue;
                if (data.substring(beginIndex, beginIndex + hint.length()).equals(hint)) {
                    if (results[i]) {
                        throw new Exception("Hint '" + hint + "' occured more than onece.");
                    }
                    results[i] = true;
                    beginIndex += hint.length();
                    changed = true;
                    continue;
                }
                if (!data.substring(endIndex - hint.length(), endIndex).equals(hint)) continue;
                if (results[i]) {
                    throw new Exception("Hint '" + hint + "' occured more than once.");
                }
                results[i] = true;
                endIndex -= hint.length();
                changed = true;
            }
        } while (changed);
        if (results[0] && results[2]) {
            throw new Exception("Hints '" + this.hints[0] + "' and '" + this.hints[2] + "' cannot be set together.");
        }
        if (results[1] && results[3]) {
            throw new Exception("Hints '" + this.hints[1] + "' and '" + this.hints[3] + "' cannot be set together.");
        }
        if (beginIndex != 0 || endIndex != data.length() - 1) {
            data = data.substring(beginIndex, endIndex);
        }
        return data;
    }
}

