/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.apicustomizer;

import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerException;
import com.streamscape.sef.network.http.server.apicustomizer.AbstractRule;
import com.streamscape.sef.network.http.server.apicustomizer.any.AnyRule;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.DataspaceAnyStatementRule;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.DataspaceCollectionRule;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.DataspaceFunctionRule;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.DataspaceODataRule;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.DataspaceQueueRule;
import com.streamscape.sef.network.http.server.apicustomizer.eventfabric.EventFabricRule;
import com.streamscape.sef.network.http.server.apicustomizer.service.ServiceGenericRule;
import com.streamscape.sef.network.http.server.apicustomizer.service.ServiceRule;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class CustomizerRuleCreator {
    private static final Map<String, Class<? extends AbstractRule>> ruleTypesMap = new LinkedHashMap<String, Class<? extends AbstractRule>>();

    private static void registerRuleType(Class<? extends AbstractRule> ruleClass) {
        ruleTypesMap.put(ruleClass.getSimpleName(), ruleClass);
    }

    public static AbstractRule createRule(String type, Map<String, String> properties) throws APICustomizerException {
        Class<? extends AbstractRule> ruleClass = ruleTypesMap.get(type);
        if (ruleClass == null) {
            throw new APICustomizerException("Invalid rule type " + type);
        }
        AbstractRule rule = CustomizerRuleCreator.createRuleInstance(type, ruleClass);
        CustomizerRuleCreator.setRuleProperties(rule, properties);
        return rule;
    }

    public static void alterRule(AbstractRule rule, Map<String, String> properties) throws APICustomizerException {
        CustomizerRuleCreator.setRuleProperties(rule, properties);
    }

    private static void setRuleProperties(AbstractRule rule, Map<String, String> properties) throws APICustomizerException {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            CustomizerRuleCreator.setRuleProperty(rule, entry.getKey(), entry.getValue());
        }
    }

    private static void setRuleProperty(AbstractRule rule, String key, String value) throws APICustomizerException {
        if (key.contains(".")) {
            Properties propertyRuleValue;
            String keyFirst = key.substring(0, key.indexOf("."));
            String keySecond = key.substring(key.indexOf(".") + 1);
            Field field = CustomizerRuleCreator.getRulePropertyField(rule, keyFirst);
            if (field.getType() != Properties.class) {
                throw new APICustomizerException("Property names with dots allowed for Property type only.");
            }
            try {
                propertyRuleValue = (Properties)field.get(rule);
                if (propertyRuleValue == null) {
                    propertyRuleValue = new Properties();
                    field.set(rule, propertyRuleValue);
                }
            }
            catch (IllegalAccessException e) {
                throw new APICustomizerException("Failed to get property value.", e);
            }
            propertyRuleValue.setProperty(keySecond, value);
        } else {
            Field field = CustomizerRuleCreator.getRulePropertyField(rule, key);
            try {
                field.set(rule, CustomizerRuleCreator.convertValue(value, field.getType()));
            }
            catch (Exception e) {
                throw new APICustomizerException("Failed to set property " + key + " to value " + value, e);
            }
        }
    }

    private static Field getRulePropertyField(AbstractRule rule, String key) throws APICustomizerException {
        Field field;
        try {
            field = ClassUtils.getClassField(rule.getClass(), key);
            field.setAccessible(true);
        }
        catch (UtilitiesException e) {
            throw new APICustomizerException("Property '" + key + "' doesn't exist for rule of type " + rule.getClass().getSimpleName() + ".");
        }
        return field;
    }

    private static Object convertValue(String value, Class<?> type) {
        if (type == String.class) {
            return value;
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return Boolean.valueOf(value.toLowerCase());
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return Integer.valueOf(value);
        }
        return value;
    }

    private static AbstractRule createRuleInstance(String type, Class<? extends AbstractRule> ruleClass) throws APICustomizerException {
        try {
            return ruleClass.newInstance();
        }
        catch (Exception e) {
            throw new APICustomizerException("Failed to create instance for rule of type " + type, e);
        }
    }

    public static List<String> listRuleTypes() {
        return new ArrayList<String>(ruleTypesMap.keySet());
    }

    static {
        CustomizerRuleCreator.registerRuleType(AnyRule.class);
        CustomizerRuleCreator.registerRuleType(DataspaceAnyStatementRule.class);
        CustomizerRuleCreator.registerRuleType(DataspaceCollectionRule.class);
        CustomizerRuleCreator.registerRuleType(DataspaceFunctionRule.class);
        CustomizerRuleCreator.registerRuleType(DataspaceODataRule.class);
        CustomizerRuleCreator.registerRuleType(DataspaceQueueRule.class);
        CustomizerRuleCreator.registerRuleType(ServiceRule.class);
        CustomizerRuleCreator.registerRuleType(EventFabricRule.class);
        CustomizerRuleCreator.registerRuleType(ServiceGenericRule.class);
    }
}

