/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.apicustomizer;

import com.streamscape.lib.utils.Pair;
import com.streamscape.sdo.http.HTTPRequest;
import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerException;
import com.streamscape.sef.network.http.server.apicustomizer.AbstractRule;
import com.streamscape.sef.network.http.server.apicustomizer.AbstractRuleWrapper;
import com.streamscape.sef.network.http.server.apicustomizer.ParameterMacros;
import com.streamscape.sef.network.http.server.apicustomizer.UriBuilder;

public class CustomizedRequestBuilder {
    private AbstractRuleWrapper<?> wrapper;

    public CustomizedRequestBuilder(AbstractRuleWrapper<?> wrapper) {
        this.wrapper = wrapper;
    }

    public HTTPRequest build(UriBuilder.UriParameterResolver resolver) throws APICustomizerException {
        HTTPRequest request = new HTTPRequest();
        if (((AbstractRule)this.wrapper.getRule()).getHttpMethod().equals("*")) {
            request.setMethod("GET");
        } else {
            request.setMethod(((AbstractRule)this.wrapper.getRule()).getHttpMethod());
        }
        request.setUri(new UriBuilder(this.wrapper.getUriMatcher()).build(resolver));
        for (Pair<String, ParameterMacros> pair : resolver.getMacroses()) {
            if (pair == null) continue;
            if (((ParameterMacros)pair.second).isUrlQueryParameter()) {
                request.addQueryParameter(((ParameterMacros)pair.second).getParameterName(), resolver.resolve(ParameterMacros.ParameterMacrosType.URL_QUERY_PARAMETER, ((ParameterMacros)pair.second).getParameterName()));
            }
            if (((ParameterMacros)pair.second).isHttpHeader()) {
                request.addHeader(((ParameterMacros)pair.second).getParameterName(), resolver.resolve(ParameterMacros.ParameterMacrosType.HTTP_HEADER_PARAMETER, ((ParameterMacros)pair.second).getParameterName()));
            }
            if (((ParameterMacros)pair.second).isHttpContent()) {
                request.setData(resolver.resolve(ParameterMacros.ParameterMacrosType.HTTP_CONTENT, ((ParameterMacros)pair.second).getParameterName()).getBytes());
            }
            if (((ParameterMacros)pair.second).isHttpContentBytes()) {
                request.setData(resolver.resolve(ParameterMacros.ParameterMacrosType.HTTP_CONTENT_BYTES, ((ParameterMacros)pair.second).getParameterName()).getBytes());
            }
            if (((ParameterMacros)pair.second).isHttpMultipartData()) {
                request.setData(resolver.resolve(ParameterMacros.ParameterMacrosType.HTTP_MULTIPART_DATA, ((ParameterMacros)pair.second).getParameterName()).getBytes());
            }
            if (!((ParameterMacros)pair.second).isHttpMultipartFilename()) continue;
            request.setData(resolver.resolve(ParameterMacros.ParameterMacrosType.HTTP_MULTIPART_FILENAME, ((ParameterMacros)pair.second).getParameterName()).getBytes());
        }
        return request;
    }
}

