/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.apicustomizer;

import com.streamscape.lib.utils.Pair;
import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerException;
import com.streamscape.sef.network.http.server.apicustomizer.AbstractRule;
import com.streamscape.sef.network.http.server.apicustomizer.AbstractRuleAccessor;
import com.streamscape.sef.network.http.server.apicustomizer.GenericRule;
import com.streamscape.sef.network.http.server.apicustomizer.HintsMatcher;
import com.streamscape.sef.network.http.server.apicustomizer.ParameterMacros;
import com.streamscape.sef.network.http.server.apicustomizer.UriMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;

public abstract class AbstractRuleWrapper<T extends AbstractRule> {
    private T rule;
    private HintsMatcher hintsMatcher;
    private UriMatcher uriMatcher;
    private ParameterMacros requestFormatMacros;
    private ParameterMacros responseFormatMacros;
    private ParameterMacros responseMimeTypeMacros;
    private ParameterMacros uriTailMacros;

    public AbstractRuleWrapper(T rule) throws APICustomizerException {
        this.rule = rule;
        this.hintsMatcher = new HintsMatcher(((AbstractRule)rule).getRequestHintJSON(), ((AbstractRule)rule).getResponseHintJSON(), ((AbstractRule)rule).getRequestHintXML(), ((AbstractRule)rule).getResponseHintXML());
        AbstractRuleWrapper.validateParameterNotNullNotEmpty(((AbstractRule)rule).getExternalURI(), "externalURI");
        AbstractRuleWrapper.validateParameterNotNullNotEmpty(((AbstractRule)rule).getHttpMethod(), "httpMethod");
        this.uriMatcher = new UriMatcher(((AbstractRule)rule).getExternalURI());
        this.requestFormatMacros = this.createParameterMacrosIfNotNullNotEmpty(((AbstractRule)rule).getRequestFormat());
        this.responseFormatMacros = this.createParameterMacrosIfNotNullNotEmpty(((AbstractRule)rule).getResponseFormat());
        this.responseMimeTypeMacros = this.createParameterMacrosIfNotNullNotEmpty(((AbstractRule)rule).getResponseMimeType());
        if (this.uriMatcher.existsParameter("*")) {
            this.uriTailMacros = this.createParameterMacrosIfNotNullNotEmpty("uri{*}");
        }
    }

    protected ParameterMacros createParameterMacrosIfNotNullNotEmpty(String value) throws APICustomizerException {
        if (value != null && value.length() > 0) {
            return new ParameterMacros(value, this.uriMatcher);
        }
        return null;
    }

    protected ParameterMacros createParameterMacrosIfNotNull(String value) throws APICustomizerException {
        if (value != null) {
            return new ParameterMacros(value, this.uriMatcher);
        }
        return null;
    }

    public T getRule() {
        return this.rule;
    }

    public HintsMatcher getHintsMatcher() {
        return this.hintsMatcher;
    }

    public UriMatcher getUriMatcher() {
        return this.uriMatcher;
    }

    public ParameterMacros getRequestFormatMacros() {
        return this.requestFormatMacros;
    }

    public ParameterMacros getResponseFormatMacros() {
        return this.responseFormatMacros;
    }

    public ParameterMacros getResponseMimeTypeMacros() {
        return this.responseMimeTypeMacros;
    }

    public ParameterMacros getUriTailMacros() {
        return this.uriTailMacros;
    }

    public List<Pair<String, ParameterMacros>> getMacroses() {
        ArrayList<Pair<String, ParameterMacros>> result = new ArrayList<Pair<String, ParameterMacros>>();
        this.addIfNotNull(result, "requestFormat", this.getRequestFormatMacros());
        this.addIfNotNull(result, "responseFormat", this.getResponseFormatMacros());
        this.addIfNotNull(result, "responseMimeType", this.getResponseMimeTypeMacros());
        this.addIfNotNull(result, "uriTail", this.getUriTailMacros());
        return result;
    }

    public static void validateParameterNotNull(Object parameter, String parameterName) throws APICustomizerException {
        if (parameter == null) {
            throw new APICustomizerException("Parameter '" + parameterName + "' not set");
        }
    }

    public static void validateParameterNotNullNotEmpty(String parameter, String parameterName) throws APICustomizerException {
        if (parameter == null || parameter.length() == 0) {
            throw new APICustomizerException("Parameter '" + parameterName + "' not set or empty.");
        }
    }

    public void validate() throws APICustomizerException {
        AbstractRuleWrapper.validateParameterNotNullNotEmpty(((AbstractRule)this.rule).getExternalURI(), "externalURI");
        AbstractRuleWrapper.validateParameterNotNullNotEmpty(((AbstractRule)this.rule).getHttpMethod(), "httpMethod");
        if (this.rule instanceof GenericRule) {
            if (this.requestFormatMacros != null) {
                this.checkMacroNotSet("requestFormat", this.requestFormatMacros, this.requestFormatMacros.isHttpContent() || this.requestFormatMacros.isHttpContentBytes() || this.requestFormatMacros.isUrlQueryParameterMap());
            }
            if (this.responseFormatMacros != null) {
                this.checkMacroNotSet("responseFormat", this.responseFormatMacros, this.responseFormatMacros.isHttpContent() || this.responseFormatMacros.isHttpContentBytes() || this.responseFormatMacros.isUrlQueryParameterMap());
            }
            if (this.responseMimeTypeMacros != null) {
                this.checkMacroNotSet("responseMimeType", this.responseMimeTypeMacros, this.responseMimeTypeMacros.isHttpContent() || this.responseMimeTypeMacros.isHttpContentBytes() || this.responseMimeTypeMacros.isUrlQueryParameterMap());
            }
        } else {
            this.checkIsValue("requestFormat", this.requestFormatMacros);
            this.checkIsValue("responseFormat", this.responseFormatMacros);
            this.checkIsValue("responseMimeType", this.responseMimeTypeMacros);
        }
        Pair<String, ParameterMacros> lastHttpContent = null;
        Pair<String, ParameterMacros> lastHttpMultipart = null;
        for (Pair<String, ParameterMacros> pair : this.getMacroses()) {
            if (((ParameterMacros)pair.second).isHttpContent() || ((ParameterMacros)pair.second).isHttpContentBytes()) {
                if (lastHttpContent != null) {
                    throw new APICustomizerException("http{content} or http{content-bytes} can be set for one parameter only, but set for " + (String)lastHttpContent.first + " and " + (String)pair.first + ".");
                }
                lastHttpContent = pair;
            }
            if (((ParameterMacros)pair.second).isHttpMultipart()) {
                lastHttpMultipart = pair;
            }
            if (lastHttpContent == null || lastHttpMultipart == null) continue;
            throw new APICustomizerException("http{content}/http{content-bytes} or http{multipart[]} can be set for one parameter only, but set for " + (String)lastHttpContent.first + " and " + (String)lastHttpMultipart.first + ".");
        }
    }

    protected void checkMacroNotSet(String parameterName, ParameterMacros parameterMacro, boolean macroIsSet) throws APICustomizerException {
        if (macroIsSet) {
            throw new APICustomizerException("Macro + '" + parameterMacro.getParameter() + "' not allowed for parameter '" + parameterName + "'.");
        }
    }

    protected void checkIsValue(String parameterName, ParameterMacros parameterMacro) throws APICustomizerException {
        if (parameterMacro != null && !parameterMacro.isAsValue()) {
            throw new APICustomizerException("Macros for '" + parameterName + "' not allowed for non Generic Service Rule.");
        }
    }

    protected void addIfNotNull(List<Pair<String, ParameterMacros>> result, String name, ParameterMacros macros) {
        if (macros != null) {
            result.add(new Pair<String, ParameterMacros>(name, macros));
        }
    }

    public abstract AbstractRuleAccessor<AbstractRuleWrapper<T>> createAccessor(Matcher var1, HttpServletRequest var2);
}

