/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.apicustomizer;

import com.streamscape.lib.utils.Pair;
import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerException;
import com.streamscape.sef.network.http.server.apicustomizer.AbstractRuleWrapper;
import com.streamscape.sef.network.http.server.apicustomizer.ParameterMacros;
import com.streamscape.sef.network.http.server.apicustomizer.UriBuilder;
import java.util.List;

public abstract class AbstractRuleParametersResolver
implements UriBuilder.UriParameterResolver {
    private AbstractRuleWrapper<?> wrapper;

    public AbstractRuleParametersResolver(AbstractRuleWrapper<?> wrapper) {
        this.wrapper = wrapper;
    }

    public AbstractRuleWrapper<?> getWrapper() {
        return this.wrapper;
    }

    @Override
    public String resolve(ParameterMacros.ParameterMacrosType type, String name) throws APICustomizerException {
        if (UriBuilder.isThisMacros(type, name, this.wrapper.getRequestFormatMacros())) {
            return this.onGetRequestFormat();
        }
        if (UriBuilder.isThisMacros(type, name, this.wrapper.getResponseFormatMacros())) {
            return this.onGetResponseFormat();
        }
        throw new APICustomizerException("Unknown parameter '" + name + "' of type '" + String.valueOf((Object)type) + "'.");
    }

    @Override
    public List<Pair<String, ParameterMacros>> getMacroses() {
        return this.wrapper.getMacroses();
    }

    protected String onGetRequestFormat() {
        return "<xml|json|string>";
    }

    protected String onGetResponseFormat() {
        return "<xml|json|string>";
    }

    protected void addIfNotNull(List<ParameterMacros> result, ParameterMacros macros) {
        if (macros != null) {
            result.add(macros);
        }
    }
}

