/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.apicustomizer;

import com.streamscape.Trace;
import com.streamscape.lib.utils.Pair;
import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerException;
import com.streamscape.sef.network.http.server.apicustomizer.AbstractRule;
import com.streamscape.sef.network.http.server.apicustomizer.AbstractRuleWrapper;
import com.streamscape.sef.network.http.server.apicustomizer.ParameterMacros;
import com.streamscape.sef.network.http.server.apicustomizer.ParameterMacrosProcessor;
import com.streamscape.sef.network.http.server.servlet.FormatAndMimeTypes;
import com.streamscape.sef.network.http.server.servlet.RestServletUtils;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import com.streamscape.sef.network.http.server.utils.MultipartFormDataHelper;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;

public abstract class AbstractRuleAccessor<T extends AbstractRuleWrapper<?>> {
    protected T ruleWrapper;
    protected HttpServletRequest request;
    protected ParameterMacrosProcessor parameterMacrosAccessor;

    protected AbstractRuleAccessor(T ruleWrapper, Matcher matcher, HttpServletRequest request) {
        this.ruleWrapper = ruleWrapper;
        this.request = request;
        this.parameterMacrosAccessor = new ParameterMacrosProcessor(request, matcher);
        this.parseRequestResponseFormatParameters();
        this.parseContentTypeHeader();
    }

    public T getRuleWrapper() {
        return this.ruleWrapper;
    }

    public int getReturnCode() {
        return ((AbstractRule)((AbstractRuleWrapper)this.ruleWrapper).getRule()).getReturnCode();
    }

    public int getErrorCode() {
        return ((AbstractRule)((AbstractRuleWrapper)this.ruleWrapper).getRule()).getErrorCode();
    }

    public boolean isSuppressJSONType() {
        return ((AbstractRule)((AbstractRuleWrapper)this.ruleWrapper).getRule()).isSuppressJSONType();
    }

    public String getUriTail() throws APICustomizerException {
        return this.parameterMacrosAccessor.getParameterValue(((AbstractRuleWrapper)this.ruleWrapper).getUriTailMacros(), true);
    }

    private void parseRequestResponseFormatParameters() {
        String format;
        if (this.request == null) {
            return;
        }
        if (!AbstractRuleAccessor.isRequestFormatSet(this.request)) {
            try {
                format = this.parameterMacrosAccessor.getParameterValue(((AbstractRuleWrapper)this.ruleWrapper).getRequestFormatMacros(), true);
                if (format != null && format.trim().length() > 0) {
                    format = this.updateFormatToSwagger(format);
                    AbstractRuleAccessor.setApiCustomizerRequestFormat(this.request, format.trim());
                }
            }
            catch (APICustomizerException exception) {
                Trace.logException(this, exception, false);
            }
        }
        if (!AbstractRuleAccessor.isResponseFormatSet(this.request)) {
            try {
                String mimeType;
                format = this.parameterMacrosAccessor.getParameterValue(((AbstractRuleWrapper)this.ruleWrapper).getResponseFormatMacros(), true);
                if (format != null && format.trim().length() > 0) {
                    format = this.updateFormatToSwagger(format);
                    AbstractRuleAccessor.setApiCustomizerResponseFormat(this.request, format.trim());
                }
                if ((mimeType = this.parameterMacrosAccessor.getParameterValue(((AbstractRuleWrapper)this.ruleWrapper).getResponseMimeTypeMacros(), true)) != null && mimeType.trim().length() > 0) {
                    AbstractRuleAccessor.setApiCustomizerResponseMimeType(this.request, mimeType.trim());
                }
            }
            catch (APICustomizerException exception) {
                Trace.logException(this, exception, false);
            }
        }
    }

    private String updateFormatToSwagger(String format) {
        if (!((String)(format = ((String)format).trim())).contains("swagger") && RestServletUtils.isSwaggerRequestForApiCustomizer(this.request)) {
            format = (String)format + ";swagger=true";
        }
        return format;
    }

    private void parseContentTypeHeader() {
        String accept;
        FormatAndMimeTypes.FormatAndMimeType formatAndMimeType;
        String contentType;
        if (this.request == null) {
            return;
        }
        String requestFormat = null;
        String responseFormat = null;
        if (!AbstractRuleAccessor.isRequestFormatSet(this.request) && (contentType = this.request.getHeader("Content-Type")) != null && (formatAndMimeType = FormatAndMimeTypes.lookupByMimeType((contentType = contentType.toLowerCase()).toLowerCase())) != null && (formatAndMimeType.isFormat("json") || formatAndMimeType.isFormat("xml") || formatAndMimeType.isFormat("string"))) {
            responseFormat = requestFormat = formatAndMimeType.getFormatWithParameters();
        }
        if (!AbstractRuleAccessor.isResponseFormatSet(this.request) && (accept = this.request.getHeader("Accept")) != null) {
            FormatAndMimeTypes.FormatAndMimeType responseFormatAndMimeType = RestServletUtils.getFormatAndMimeTypeFrom(accept = accept.toLowerCase(), "application/json");
            if (responseFormatAndMimeType == null) {
                RestServletUtils.getFormatAndMimeTypeFrom(accept, "application/xml");
            }
            if (responseFormatAndMimeType == null) {
                RestServletUtils.getFormatAndMimeTypeFrom(accept, "text/plain");
            }
            if (responseFormatAndMimeType == null) {
                RestServletUtils.getFormatAndMimeTypeFrom(accept, "text/html");
            }
            if (responseFormatAndMimeType != null) {
                responseFormat = responseFormatAndMimeType.getFormatWithParameters();
            }
        }
        if (requestFormat != null) {
            AbstractRuleAccessor.setApiCustomizerRequestFormat(this.request, requestFormat);
        }
        if (responseFormat != null) {
            AbstractRuleAccessor.setApiCustomizerResponseFormat(this.request, responseFormat);
        }
    }

    public static boolean isRequestFormatSet(HttpServletRequest request) {
        return request.getAttribute("API_CUSTOMIZER_REQUEST_FORMAT") != null;
    }

    public static boolean isResponseFormatSet(HttpServletRequest request) {
        return request.getAttribute("API_CUSTOMIZER_RESPONSE_FORMAT") != null;
    }

    public static void setApiCustomizerRequestFormat(HttpServletRequest request, String format) {
        request.setAttribute("API_CUSTOMIZER_REQUEST_FORMAT", format);
    }

    public static void setApiCustomizerResponseFormat(HttpServletRequest request, String format) {
        request.setAttribute("API_CUSTOMIZER_RESPONSE_FORMAT", format);
    }

    public static void setApiCustomizerResponseMimeType(HttpServletRequest request, String format) {
        request.setAttribute("API_CUSTOMIZER_RESPONSE_MIME_TYPE", format);
    }

    public static String splitDataAndHints(HttpServletRequest request, AbstractRuleWrapper<?> wrapper, String data) throws APICustomizerException {
        try {
            boolean[] results = new boolean[4];
            data = wrapper.getHintsMatcher().matchData(data, results);
            String requestFormat = null;
            String responseFormat = null;
            if (results[0]) {
                requestFormat = "json";
            } else if (results[2]) {
                requestFormat = "xml";
            }
            if (results[1]) {
                responseFormat = "json";
            } else if (results[3]) {
                responseFormat = "xml";
            }
            if (request != null) {
                if (requestFormat != null) {
                    AbstractRuleAccessor.setApiCustomizerRequestFormat(request, requestFormat);
                }
                if (responseFormat != null) {
                    AbstractRuleAccessor.setApiCustomizerResponseFormat(request, responseFormat);
                }
            }
            return data;
        }
        catch (Exception exception) {
            throw new APICustomizerException("Failed to extract hints from data: " + exception.getMessage());
        }
    }

    protected String splitDataAndHints(String data) throws APICustomizerException {
        if (this.request == null || !AbstractRuleAccessor.isResponseFormatSet(this.request) || !AbstractRuleAccessor.isRequestFormatSet(this.request)) {
            return AbstractRuleAccessor.splitDataAndHints(this.request, this.ruleWrapper, data);
        }
        return data;
    }

    public String customizeQuery(HttpServletRequest request) throws APICustomizerException {
        if (this.getReturnCode() != 0) {
            request.setAttribute("API_CUSTOMIZER_RETURN_CODE", this.getReturnCode());
        }
        if (this.getErrorCode() != 0) {
            request.setAttribute("API_CUSTOMIZER_ERROR_CODE", this.getErrorCode());
        }
        if (this.isSuppressJSONType()) {
            request.setAttribute("API_CUSTOMIZER_SUPPRESS_JSON_TYPE", this.isSuppressJSONType());
        }
        StringBuilder queryBuilder = new StringBuilder();
        this.onCustomizeQuery(queryBuilder);
        return queryBuilder.toString();
    }

    public abstract String customizeMethod() throws APICustomizerException;

    public abstract String customizeUri() throws APICustomizerException;

    protected abstract void onCustomizeQuery(StringBuilder var1) throws APICustomizerException;

    protected void appendIfNotNullNotEmpty(StringBuilder builder, String name, String value) {
        if (value != null && value.length() > 0) {
            this.append(builder, name, value);
        }
    }

    protected void append(StringBuilder builder, String name, String value) {
        if (builder.length() > 0) {
            builder.append("&");
        }
        builder.append(HTTPUtils.encodeString(name));
        if (value != null && value.length() > 0) {
            builder.append("=").append(HTTPUtils.encodeString(value));
        }
    }

    public void afterprocess() {
        List<FileItem> parts;
        HashSet<String> multipartParameterNames = new HashSet<String>();
        for (Pair<String, ParameterMacros> pair : ((AbstractRuleWrapper)this.ruleWrapper).getMacroses()) {
            if (!((ParameterMacros)pair.second).isHttpMultipart()) continue;
            multipartParameterNames.add((String)pair.first);
        }
        if (multipartParameterNames.size() > 0 && (parts = MultipartFormDataHelper.getMultiParts(this.request)) != null) {
            Iterator<FileItem> iterator = parts.iterator();
            while (iterator.hasNext()) {
                FileItem item = iterator.next();
                if (multipartParameterNames.contains(item.getFieldName())) continue;
                MultipartFormDataHelper.removeTemporaryMultiPartFile(item);
                iterator.remove();
            }
        }
    }
}

