/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.apicustomizer;

import com.streamscape.lib.utils.Utils;
import com.streamscape.omf.serializer.SerializerException;
import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerConfiguration;
import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerException;
import com.streamscape.sef.network.http.server.apicustomizer.AbstractRule;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class APICustomizerImporterExporter {
    public static String exportToJson(APICustomizerConfiguration configuration, Set<String> includeRuleIds, Set<String> includeRuleTypes) throws APICustomizerException {
        ArrayList rules = new ArrayList(configuration.listAllRules().stream().filter(rule -> includeRuleIds == null || includeRuleIds.size() == 0 || includeRuleIds.contains(rule.getRuleId())).filter(rule -> includeRuleTypes == null || includeRuleTypes.size() == 0 || includeRuleTypes.contains(rule.getClass().getSimpleName())).collect(Collectors.toList()));
        try {
            return HTTPUtils.getJsonSerializerForJaxrx().withPrettyPrint(true).serialize(rules);
        }
        catch (SerializerException e) {
            throw new APICustomizerException("Failed to serialize rules.", e);
        }
    }

    public static void importFromJson(APICustomizerConfiguration configuration, String json, ImportRulesMethod importRulesMethod) throws APICustomizerException {
        APICustomizerConfiguration newConfiguration = new APICustomizerConfiguration(configuration);
        if (importRulesMethod == ImportRulesMethod.REPLACE) {
            newConfiguration.clear();
        }
        try {
            List rules = HTTPUtils.getJsonSerializerForJaxrx().deserialize(ArrayList.class, json);
            for (AbstractRule rule : rules) {
                newConfiguration.removeRuleById(rule.getRuleId());
                newConfiguration.addRule(rule);
            }
            if (importRulesMethod == ImportRulesMethod.REPLACE) {
                configuration.clear();
            }
            for (AbstractRule rule : rules) {
                configuration.removeRuleById(rule.getRuleId());
                configuration.addRule(rule);
            }
        }
        catch (SerializerException e) {
            throw new APICustomizerException("Failed to serialize rules. " + Utils.formatExceptionWithUnrepeatedCauses(e));
        }
    }

    public static enum ImportRulesMethod {
        REPLACE,
        MERGE;

    }
}

