/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.apicustomizer;

import com.streamscape.sef.network.http.server.apicustomizer.APICustomizer;
import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerException;
import com.streamscape.sef.network.http.server.apicustomizer.AbstractRule;
import com.streamscape.sef.network.http.server.apicustomizer.any.AnyRule;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.AbstractDataspaceRule;
import com.streamscape.sef.network.http.server.apicustomizer.eventfabric.EventFabricRule;
import com.streamscape.sef.network.http.server.apicustomizer.service.AbstractServiceRule;
import com.streamscape.sef.network.http.server.apicustomizer.service.ServiceGenericRule;
import com.streamscape.sef.network.http.server.apicustomizer.service.ServiceRule;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class APICustomizerConfiguration {
    private List<AbstractServiceRule> serviceRules = new ArrayList<AbstractServiceRule>();
    private List<EventFabricRule> eventFabricRules = new ArrayList<EventFabricRule>();
    private List<AbstractDataspaceRule> dataspaceRules = new ArrayList<AbstractDataspaceRule>();
    private List<AnyRule> anyRules = new ArrayList<AnyRule>();

    public APICustomizerConfiguration() {
    }

    public APICustomizerConfiguration(APICustomizerConfiguration configuration) {
        this.serviceRules = new ArrayList<AbstractServiceRule>(configuration.serviceRules);
        this.eventFabricRules = new ArrayList<EventFabricRule>(configuration.eventFabricRules);
        this.dataspaceRules = new ArrayList<AbstractDataspaceRule>(configuration.dataspaceRules);
        this.anyRules = new ArrayList<AnyRule>(configuration.anyRules);
    }

    public List<AbstractRule> listAllRules() {
        ArrayList<AbstractRule> rules = new ArrayList<AbstractRule>();
        if (this.serviceRules != null) {
            rules.addAll(this.serviceRules);
        }
        if (this.eventFabricRules != null) {
            rules.addAll(this.eventFabricRules);
        }
        if (this.dataspaceRules != null) {
            rules.addAll(this.dataspaceRules);
        }
        if (this.anyRules != null) {
            rules.addAll(this.anyRules);
        }
        return rules;
    }

    public List<AbstractServiceRule> listAllServiceRules() {
        return this.serviceRules;
    }

    public List<ServiceRule> listServiceRules() {
        ArrayList<ServiceRule> rules = new ArrayList<ServiceRule>();
        for (AbstractServiceRule rule : this.serviceRules) {
            if (!(rule instanceof ServiceRule)) continue;
            rules.add((ServiceRule)rule);
        }
        return rules;
    }

    public List<ServiceGenericRule> listServiceGenericRules() {
        ArrayList<ServiceGenericRule> rules = new ArrayList<ServiceGenericRule>();
        for (AbstractServiceRule rule : this.serviceRules) {
            if (!(rule instanceof ServiceGenericRule)) continue;
            rules.add((ServiceGenericRule)rule);
        }
        return rules;
    }

    public void setAllServiceRules(List<AbstractServiceRule> serviceRules) throws APICustomizerException {
        List<AbstractServiceRule> bkpServiceRules = this.serviceRules;
        this.serviceRules = serviceRules;
        try {
            APICustomizer.validate(this);
        }
        catch (APICustomizerException exception) {
            this.serviceRules = bkpServiceRules;
            throw exception;
        }
    }

    public void setServiceRules(List<ServiceRule> serviceRules) throws APICustomizerException {
        ArrayList<AbstractServiceRule> bkpServiceRules = new ArrayList<AbstractServiceRule>(this.serviceRules);
        Iterator<AbstractServiceRule> iterator = this.serviceRules.iterator();
        while (iterator.hasNext()) {
            if (!(iterator.next() instanceof ServiceRule)) continue;
            iterator.remove();
        }
        this.serviceRules.addAll(serviceRules);
        try {
            APICustomizer.validate(this);
        }
        catch (APICustomizerException exception) {
            this.serviceRules = bkpServiceRules;
            throw exception;
        }
    }

    public void setServiceGenericRules(List<ServiceGenericRule> serviceGenericRules) throws APICustomizerException {
        ArrayList<AbstractServiceRule> bkpServiceRules = new ArrayList<AbstractServiceRule>(this.serviceRules);
        Iterator<AbstractServiceRule> iterator = this.serviceRules.iterator();
        while (iterator.hasNext()) {
            if (!(iterator.next() instanceof ServiceGenericRule)) continue;
            iterator.remove();
        }
        this.serviceRules.addAll(serviceGenericRules);
        try {
            APICustomizer.validate(this);
        }
        catch (APICustomizerException exception) {
            this.serviceRules = bkpServiceRules;
            throw exception;
        }
    }

    public void addServiceRule(ServiceRule serviceRule) throws APICustomizerException {
        this.initServiceRules();
        this.serviceRules.add(serviceRule);
        try {
            APICustomizer.validate(this);
        }
        catch (APICustomizerException exception) {
            this.serviceRules.remove(this.serviceRules.size() - 1);
            throw exception;
        }
    }

    public void addServiceGenericRule(ServiceRule serviceGenericRule) throws APICustomizerException {
        this.initServiceRules();
        this.serviceRules.add(serviceGenericRule);
        try {
            APICustomizer.validate(this);
        }
        catch (APICustomizerException exception) {
            this.serviceRules.remove(this.serviceRules.size() - 1);
            throw exception;
        }
    }

    private synchronized void initServiceRules() {
        if (this.serviceRules == null) {
            this.serviceRules = new ArrayList<AbstractServiceRule>();
        }
    }

    public List<EventFabricRule> listEventFabricRules() {
        return this.eventFabricRules;
    }

    public void setEventFabricRules(List<EventFabricRule> eventFabricRules) throws APICustomizerException {
        List<EventFabricRule> bkpEventFabricRules = this.eventFabricRules;
        this.eventFabricRules = eventFabricRules;
        try {
            APICustomizer.validate(this);
        }
        catch (APICustomizerException exception) {
            this.eventFabricRules = bkpEventFabricRules;
            throw exception;
        }
    }

    public void addEventFabricRule(EventFabricRule eventFabricRule) throws APICustomizerException {
        this.initEventFabricRules();
        this.eventFabricRules.add(eventFabricRule);
        try {
            APICustomizer.validate(this);
        }
        catch (APICustomizerException exception) {
            this.eventFabricRules.remove(this.eventFabricRules.size() - 1);
            throw exception;
        }
    }

    private synchronized void initEventFabricRules() {
        if (this.eventFabricRules == null) {
            this.eventFabricRules = new ArrayList<EventFabricRule>();
        }
    }

    public List<AbstractDataspaceRule> listDataspaceRules() {
        return this.dataspaceRules;
    }

    public void setDataspaceRules(List<AbstractDataspaceRule> dataspaceRules) throws APICustomizerException {
        List<AbstractDataspaceRule> bkpDataspaceRules = this.dataspaceRules;
        this.dataspaceRules = dataspaceRules;
        try {
            APICustomizer.validate(this);
        }
        catch (APICustomizerException exception) {
            this.dataspaceRules = bkpDataspaceRules;
            throw exception;
        }
    }

    public void addDataspaceRule(AbstractDataspaceRule dataspaceRule) throws APICustomizerException {
        this.initDataspaceRules();
        this.dataspaceRules.add(dataspaceRule);
        try {
            APICustomizer.validate(this);
        }
        catch (APICustomizerException exception) {
            this.dataspaceRules.remove(this.dataspaceRules.size() - 1);
            throw exception;
        }
    }

    private synchronized void initDataspaceRules() {
        if (this.dataspaceRules == null) {
            this.dataspaceRules = new ArrayList<AbstractDataspaceRule>();
        }
    }

    public List<AnyRule> listAnyRules() {
        return this.anyRules != null ? this.anyRules : new ArrayList<AnyRule>();
    }

    public void setAnyRules(List<AnyRule> anyRules) throws APICustomizerException {
        List<AnyRule> bkpAnyRules = this.anyRules;
        this.anyRules = anyRules;
        try {
            APICustomizer.validate(this);
        }
        catch (APICustomizerException exception) {
            this.anyRules = bkpAnyRules;
            throw exception;
        }
    }

    public void addAnyRule(AnyRule anyRule) throws APICustomizerException {
        this.initAnyRules();
        this.anyRules.add(anyRule);
        try {
            APICustomizer.validate(this);
        }
        catch (APICustomizerException exception) {
            this.anyRules.remove(this.anyRules.size() - 1);
            throw exception;
        }
    }

    private synchronized void initAnyRules() {
        if (this.anyRules == null) {
            this.anyRules = new ArrayList<AnyRule>();
        }
    }

    public void addRule(AbstractRule rule) throws APICustomizerException {
        if (rule instanceof AnyRule) {
            this.addAnyRule((AnyRule)rule);
        } else if (rule instanceof AbstractDataspaceRule) {
            this.addDataspaceRule((AbstractDataspaceRule)rule);
        } else if (rule instanceof EventFabricRule) {
            this.addEventFabricRule((EventFabricRule)rule);
        } else if (rule instanceof ServiceGenericRule) {
            this.addServiceGenericRule((ServiceRule)rule);
        } else if (rule instanceof ServiceRule) {
            this.addServiceRule((ServiceRule)rule);
        } else {
            throw new APICustomizerException("Invalid rule " + rule.getClass().getName());
        }
    }

    public void removeRuleById(String ruleId) {
        this.removeRileByIdFrom(this.anyRules, ruleId);
        this.removeRileByIdFrom(this.serviceRules, ruleId);
        this.removeRileByIdFrom(this.eventFabricRules, ruleId);
        this.removeRileByIdFrom(this.dataspaceRules, ruleId);
    }

    private void removeRileByIdFrom(List<? extends AbstractRule> rules, String ruleId) {
        if (rules == null) {
            return;
        }
        AbstractRule rule = rules.stream().filter(r -> r.getRuleId().equals(ruleId)).findAny().orElse(null);
        if (rule == null) {
            return;
        }
        rules.remove(rule);
    }

    public void clear() {
        this.anyRules.clear();
        this.serviceRules.clear();
        this.eventFabricRules.clear();
        this.dataspaceRules.clear();
    }
}

