/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.apicustomizer;

import com.streamscape.Trace;
import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerConfiguration;
import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerException;
import com.streamscape.sef.network.http.server.apicustomizer.AbstractRule;
import com.streamscape.sef.network.http.server.apicustomizer.AbstractRuleAccessor;
import com.streamscape.sef.network.http.server.apicustomizer.AbstractRuleWrapper;
import com.streamscape.sef.network.http.server.apicustomizer.UriMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;

public class APICustomizer {
    public static final String API_CUSTOMIZER_RETURN_CODE = "API_CUSTOMIZER_RETURN_CODE";
    public static final String API_CUSTOMIZER_ERROR_CODE = "API_CUSTOMIZER_ERROR_CODE";
    public static final String API_CUSTOMIZER_SUPPRESS_JSON_TYPE = "API_CUSTOMIZER_SUPPRESS_JSON_TYPE";
    public static final String API_CUSTOMIZER_RESPONSE_FORMAT = "API_CUSTOMIZER_RESPONSE_FORMAT";
    public static final String API_CUSTOMIZER_RESPONSE_MIME_TYPE = "API_CUSTOMIZER_RESPONSE_MIME_TYPE";
    public static final String API_CUSTOMIZER_REQUEST_FORMAT = "API_CUSTOMIZER_REQUEST_FORMAT";
    public static final String API_CUSTOMIZER_ORIGINAL_METHOD = "API_CUSTOMIZER_ORIGINAL_METHOD";
    public static final String API_CUSTOMIZER_ORIGINAL_URI = "API_CUSTOMIZER_ORIGINAL_URI";
    public static final String API_CUSTOMIZER_ORIGINAL_QUERY_PARAMETERS = "API_CUSTOMIZER_ORIGINAL_QUERY_PARAMETERS";
    private Map<String, List<AbstractRuleWrapper>> ruleWrappersMap;

    public void init(APICustomizerConfiguration configuration) throws APICustomizerException {
        Trace.logDebug(this, "APICustomizer initializing...");
        this.ruleWrappersMap = APICustomizer.createRuleWrappersMap(configuration);
        APICustomizer.validate(this.ruleWrappersMap);
        if (this.ruleWrappersMap != null && this.ruleWrappersMap.size() > 0) {
            Trace.logInfo(this, "APICustomizer has " + this.ruleWrappersMap.size() + " rules.");
            for (Map.Entry<String, List<AbstractRuleWrapper>> entry : this.ruleWrappersMap.entrySet()) {
                for (AbstractRuleWrapper wrapper : entry.getValue()) {
                    Trace.logDebug(this, "APICustomizer rule: " + ((AbstractRule)wrapper.getRule()).toString());
                }
            }
        } else {
            Trace.logDebug(this, "APICustomizer has no rules.");
        }
        Trace.logInfo(this, "APICustomizer initialized.");
    }

    public AbstractRuleWrapper getRuleWrapperFor(String httpMethod, String url) {
        if (this.ruleWrappersMap == null || this.ruleWrappersMap.size() == 0) {
            return null;
        }
        if (httpMethod != null) {
            Function<List, AbstractRuleWrapper> match = rulesByMethod -> {
                Matcher matcher;
                for (AbstractRuleWrapper wrapper : rulesByMethod) {
                    matcher = wrapper.getUriMatcher().matcher(url);
                    if (!matcher.matches()) continue;
                    return wrapper;
                }
                for (AbstractRuleWrapper wrapper : rulesByMethod) {
                    matcher = wrapper.getUriMatcher().matcher(UriMatcher.normalizeUri(url));
                    if (!matcher.matches()) continue;
                    return wrapper;
                }
                for (AbstractRuleWrapper wrapper : rulesByMethod) {
                    matcher = wrapper.getUriMatcher().matcher(UriMatcher.normalizeUriWithLastSlashRemove(url));
                    if (!matcher.matches()) continue;
                    return wrapper;
                }
                for (AbstractRuleWrapper wrapper : rulesByMethod) {
                    matcher = wrapper.getUriMatcher().matcher(UriMatcher.normalizeUriWithAddLastSlash(url));
                    if (!matcher.matches()) continue;
                    return wrapper;
                }
                return null;
            };
            AbstractRuleWrapper wrapper = match.apply(this.getRuleWrapperByMethod(httpMethod));
            if (wrapper == null) {
                wrapper = match.apply(this.getRuleWrapperByMethod("*"));
            }
            return wrapper;
        }
        return null;
    }

    public AbstractRuleAccessor getRuleFor(String httpMethod, String url, HttpServletRequest request) {
        if (this.ruleWrappersMap == null || this.ruleWrappersMap.size() == 0) {
            return null;
        }
        if (httpMethod != null) {
            Function<List, AbstractRuleAccessor> match = rulesByMethod -> {
                Matcher matcher;
                for (AbstractRuleWrapper wrapper : rulesByMethod) {
                    matcher = wrapper.getUriMatcher().matcher(UriMatcher.normalizeUri(url));
                    if (!matcher.matches()) continue;
                    if (Trace.isDebugEnabled(this.getClass())) {
                        Trace.logDebug(this, "URL '" + url + "' matches to rule " + String.valueOf(wrapper.getRule()));
                    }
                    return wrapper.createAccessor(matcher, request);
                }
                for (AbstractRuleWrapper wrapper : rulesByMethod) {
                    matcher = wrapper.getUriMatcher().matcher(UriMatcher.normalizeUriWithLastSlashRemove(url));
                    if (!matcher.matches()) continue;
                    if (Trace.isDebugEnabled(this.getClass())) {
                        Trace.logDebug(this, "URL '" + url + "' matches to rule " + String.valueOf(wrapper.getRule()));
                    }
                    return wrapper.createAccessor(matcher, request);
                }
                for (AbstractRuleWrapper wrapper : rulesByMethod) {
                    matcher = wrapper.getUriMatcher().matcher(UriMatcher.normalizeUriWithAddLastSlash(url));
                    if (!matcher.matches()) continue;
                    if (Trace.isDebugEnabled(this.getClass())) {
                        Trace.logDebug(this, "URL '" + url + "' matches to rule " + String.valueOf(wrapper.getRule()));
                    }
                    return wrapper.createAccessor(matcher, request);
                }
                return null;
            };
            AbstractRuleAccessor accessor = match.apply(this.getRuleWrapperByMethod(httpMethod));
            if (accessor == null) {
                accessor = match.apply(this.getRuleWrapperByMethod("*"));
            }
            return accessor;
        }
        return null;
    }

    private List<AbstractRuleWrapper> getRuleWrapperByMethod(String httpMethod) {
        List<AbstractRuleWrapper> rulesByMethod = this.ruleWrappersMap.get(httpMethod.toUpperCase());
        if (rulesByMethod == null) {
            rulesByMethod = this.ruleWrappersMap.get("*");
        }
        if (rulesByMethod == null) {
            rulesByMethod = Collections.EMPTY_LIST;
        }
        return rulesByMethod;
    }

    public static void validate(APICustomizerConfiguration configuration) throws APICustomizerException {
        Map<String, List<AbstractRuleWrapper>> wrappers = APICustomizer.createRuleWrappersMap(configuration);
        APICustomizer.validate(wrappers);
    }

    public static void validate(Map<String, List<AbstractRuleWrapper>> wrappers) throws APICustomizerException {
        for (Map.Entry<String, List<AbstractRuleWrapper>> entry : wrappers.entrySet()) {
            for (int i = 0; i < entry.getValue().size(); ++i) {
                entry.getValue().get(i).validate();
                String someMatchedUrl = entry.getValue().get(i).getUriMatcher().getMatchedUrl();
                for (int j = 0; j < entry.getValue().size(); ++j) {
                    if (i == j || !entry.getValue().get(j).getUriMatcher().matcher(someMatchedUrl).matches()) continue;
                    throw new APICustomizerException("External URLs should be unique. URLs '" + ((AbstractRule)entry.getValue().get(i).getRule()).getExternalURI() + "' and '" + ((AbstractRule)entry.getValue().get(j).getRule()).getExternalURI() + "' not unique!");
                }
            }
        }
    }

    private static Map<String, List<AbstractRuleWrapper>> createRuleWrappersMap(APICustomizerConfiguration configuration) throws APICustomizerException {
        HashMap<String, List<AbstractRuleWrapper>> result = new HashMap<String, List<AbstractRuleWrapper>>();
        if (configuration == null) {
            return result;
        }
        List<AbstractRule> rules = configuration.listAllRules();
        if (rules == null) {
            return result;
        }
        for (AbstractRule rule : rules) {
            if (rule.getHttpMethod() == null) {
                throw new APICustomizerException("Http method is null for rule " + String.valueOf(rule) + ".");
            }
            ArrayList<AbstractRuleWrapper> rulesByMethod = (ArrayList<AbstractRuleWrapper>)result.get(rule.getHttpMethod().toUpperCase());
            if (rulesByMethod == null) {
                rulesByMethod = new ArrayList<AbstractRuleWrapper>();
                result.put(rule.getHttpMethod().toUpperCase(), rulesByMethod);
            }
            rulesByMethod.add(rule.createWrapper());
        }
        return result;
    }
}

