/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.acceptor;

import com.streamscape.Trace;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.omf.java.Utils;
import com.streamscape.repository.cli.RepositoryAccessor;
import com.streamscape.repository.enums.PackageType;
import com.streamscape.repository.pkg.Package;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.moderator.FabricNodeRole;
import com.streamscape.sef.network.LinkProtocol;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptor;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptorApplicationsUtils;
import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerConfiguration;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.AbstractDataspaceRule;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.DataspaceFunctionRule;
import com.streamscape.sef.network.http.server.authentication.RealmManager;
import com.streamscape.sef.network.http.server.authentication.delegate.DelegateAuthenticationManager;
import com.streamscape.sef.network.http.server.config.RealmInfo;
import com.streamscape.sef.network.http.server.config.ServletInfo;
import com.streamscape.sef.network.http.server.jetty.JettyAdvancedProperties;
import com.streamscape.sef.network.http.server.swagger.SwaggerServlet;
import com.streamscape.sef.network.mf.admin.AbstractAcceptorFactory;
import com.streamscape.sef.network.mf.admin.Acceptor;
import com.streamscape.sef.network.mf.admin.AcceptorFactoryException;
import com.streamscape.sef.pkg.PackageDescriptor;
import com.streamscape.sef.utils.Configurator;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.Properties;

public class HTTPAcceptorFactory
extends AbstractAcceptorFactory {
    private static final String HTTP_ACCEPTOR = HTTPAcceptor.class.getSimpleName();
    private DelegateAuthenticationManager delegateAuthenticationManager;
    private static final String SWAGGER_LIB_NAME = "stswagger-client-gen";

    public HTTPAcceptorFactory() {
        super("HTTPAcceptorFactory", HTTP_ACCEPTOR, "/sys/network/acceptors/http");
    }

    @Override
    protected Class getDefaultAcceptorClass() {
        return HTTPAcceptor.class;
    }

    @Override
    public LinkProtocol getAcceptorProtocol() {
        return LinkProtocol.HTTP;
    }

    @Override
    public void init(RuntimeContext context) throws FabricException {
        this.updateAcceptorsProperties(context);
        super.init(context);
    }

    @Override
    protected void completeInit(RuntimeContext context) throws Exception {
        this.delegateAuthenticationManager = new DelegateAuthenticationManager();
        this.initNewDefaultAcceptorInMnode(context);
    }

    private void initNewDefaultAcceptorInMnode(RuntimeContext context) {
        if (context.getNodeRole() == FabricNodeRole.MANAGEMENT_NODE) {
            HTTPAcceptor acceptor = this.lookupAcceptor("Default");
            if (acceptor != null) {
                try {
                    HTTPAcceptorApplicationsUtils.addRulesForOsAndDash(acceptor.getConfiguration());
                    this.saveAcceptor(acceptor);
                }
                catch (Exception exception) {
                    Trace.logError(this, "Adding default OS rules to acceptor '" + acceptor.getName() + "' failed. Cause: " + Utils.formatExceptionWithUnrepeatedCauses(exception));
                    Trace.logException(this, exception, true);
                }
            }
            if (acceptor != null && acceptor.isNewlyCreated()) {
                acceptor.setAutoStart(true);
                try {
                    this.saveAcceptor(acceptor);
                }
                catch (AcceptorFactoryException exception) {
                    Trace.logError(this, "Saving HTTP acceptor '" + acceptor.getName() + "' configuration failed. Cause: " + exception.getMessage());
                }
                this.copyQuiltWar(context, acceptor);
                this.createSwaggerPackage(context);
            }
        }
    }

    private void copyQuiltWar(RuntimeContext context, HTTPAcceptor acceptor) {
        File quiltDir = new File(context.getSTRootDir() + "/web/quilt");
        File warDir = new File(acceptor.getWebArchiveDir());
        if (quiltDir.exists()) {
            try {
                FileIOUtils.newFileDir(warDir.getAbsolutePath());
                FileIOUtils.copyFileDir(quiltDir, warDir);
                Trace.logInfo(this, "Quilt WARs copied to '" + warDir.getCanonicalFile().getPath() + "'.");
            }
            catch (Throwable exception) {
                Trace.logException(this, exception, true);
                Trace.logError(this, "Copying Quilt WARs from '" + quiltDir.getAbsolutePath() + "' to '" + warDir.getAbsolutePath() + "' failed.");
            }
        }
    }

    private void createSwaggerPackage(RuntimeContext context) {
        String jar = "stswagger-client-gen.jar";
        File jarFile = new File(context.getSTRootDir() + "/platform/lib", jar);
        if (jarFile.exists()) {
            try {
                RepositoryAccessor accessor = context.getRepositoryAccessor();
                accessor.addArchive(jarFile);
                Package pkg = Package.create(PackageType.collection, SWAGGER_LIB_NAME, jar);
                accessor.addPackage(pkg);
                context.getPackageManifestManager().addPackage(PackageDescriptor.create(pkg, true));
                Trace.logInfo(this, "Swagger Client package created.");
            }
            catch (Throwable exception) {
                Trace.logException(this, exception, true);
                Trace.logError(this, "Creating Swagger Client package failed.");
            }
        }
    }

    @Override
    public Acceptor createAcceptor(String acceptorName, Class acceptorClass) {
        if (acceptorClass.equals(HTTPAcceptor.class)) {
            return new HTTPAcceptor(acceptorName);
        }
        return null;
    }

    @Override
    public HTTPAcceptor lookupAcceptor(String acceptorName) {
        return (HTTPAcceptor)super.lookupAcceptor(acceptorName);
    }

    public DelegateAuthenticationManager getDelegateAuthenticationManager() {
        return this.delegateAuthenticationManager;
    }

    @Override
    protected void addSupportedTypes() {
        this.addSupportedType("HTTPAcceptor", HTTPAcceptor.class, "Core HTTP Acceptor object.");
    }

    @Override
    protected String getDefaultName(SemanticType type) {
        return "Default";
    }

    private void updateAcceptorsProperties(RuntimeContext context) throws FabricException {
        try {
            Configurator<HTTPAcceptor> configurator = new Configurator<HTTPAcceptor>(this.namespace);
            for (String objectName : configurator.listBoundNames()) {
                try {
                    APICustomizerConfiguration apiCustomizerConfiguration;
                    RealmInfo fabricRealm;
                    boolean found;
                    HTTPAcceptor acceptor = (HTTPAcceptor)configurator.loadObject(objectName);
                    boolean updated = false;
                    Properties properties = acceptor.getConfiguration().getAdvancedProperties();
                    int size = properties.size();
                    JettyAdvancedProperties.getDefaultPropertiesInfo().forEach((key, value) -> properties.putIfAbsent(key, Objects.toString(value.getValue(), null)));
                    updated = properties.size() != size;
                    String timezone = (String)properties.get("jetstream.request.logger.timezone");
                    if (timezone == null || timezone.equalsIgnoreCase("GMT") || timezone.equalsIgnoreCase("")) {
                        properties.put("jetstream.request.logger.timezone", "LOCAL");
                        updated = true;
                    }
                    if (RealmManager.getRealmInfo(acceptor.getConfiguration().getRealms(), "/odata/v4") == null) {
                        RealmInfo odataRealm = new RealmInfo("OData", acceptor.getRuntimeContext());
                        odataRealm.addGroup("HTTP");
                        odataRealm.addGroup("Admins");
                        acceptor.getConfiguration().getRealms().put("/odata/v4", odataRealm);
                        updated = true;
                    }
                    if (RealmManager.getRealmInfo(acceptor.getConfiguration().getRealms(), "/swagger/v2") == null) {
                        RealmInfo swaggerRealm = new RealmInfo("Swagger", acceptor.getRuntimeContext());
                        swaggerRealm.addGroup("HTTP");
                        swaggerRealm.addGroup("Admins");
                        acceptor.getConfiguration().getRealms().put("/swagger/v2", swaggerRealm);
                        updated = true;
                    }
                    if (!(found = acceptor.getConfiguration().getServlets().stream().anyMatch(info -> info.getServletPath().startsWith("/swagger/v2")))) {
                        acceptor.getConfiguration().getServlets().add(new ServletInfo("/swagger/v2/*", SwaggerServlet.class.getName()));
                        updated = true;
                    }
                    if ((fabricRealm = RealmManager.getRealmInfo(acceptor.getConfiguration().getRealms(), "/fabric")) != null && !fabricRealm.listGroups().contains("Operators")) {
                        fabricRealm.addGroup("Operators");
                        updated = true;
                    }
                    if (RealmManager.getRealmInfo(acceptor.getConfiguration().getRealms(), "/chart") == null) {
                        RealmInfo chartRealm = new RealmInfo("ReactiveCharts", acceptor.getRuntimeContext());
                        chartRealm.addGroup("HTTP");
                        chartRealm.addGroup("Admins");
                        chartRealm.addGroup("Operators");
                        acceptor.getConfiguration().getRealms().put("/chart", chartRealm);
                        updated = true;
                    }
                    if ((apiCustomizerConfiguration = acceptor.getConfiguration().getAPICustomizerConfiguration()) != null) {
                        boolean found2;
                        List<AbstractDataspaceRule> rules = apiCustomizerConfiguration.listDataspaceRules();
                        boolean bl = found2 = rules != null && rules.stream().anyMatch(rule -> "/chart/{payload}/{cid}".equals(rule.getExternalURI()));
                        if (!found2) {
                            DataspaceFunctionRule chartRule = new DataspaceFunctionRule();
                            chartRule.setExternalURI("/chart/{payload}/{cid}");
                            chartRule.setHttpMethod("GET");
                            chartRule.setResponseFormat("string");
                            chartRule.setResponseMimeType("application/json");
                            chartRule.setDataspaceName("TSPACE.qlt$Quilt");
                            chartRule.setFunctionName("chartGet");
                            Properties chartRuleParameters = new Properties();
                            chartRuleParameters.setProperty("payload", "uri{payload}");
                            chartRuleParameters.setProperty("cid", "uri{cid}");
                            chartRuleParameters.setProperty("args", "url_query{&args}");
                            chartRule.setParameters(chartRuleParameters);
                            try {
                                apiCustomizerConfiguration.addDataspaceRule(chartRule);
                            }
                            catch (Exception exception) {
                                Trace.logException(this, exception, false);
                            }
                            updated = true;
                        }
                    }
                    if (!updated) continue;
                    configurator.bindObject(objectName, acceptor);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            throw new FabricException("Initialization of " + this.factoryName + " failed.", exception);
        }
    }

    public void updateDropBox(RuntimeContext context) throws FabricException {
        try {
            for (String string : this.listAcceptors()) {
            }
        }
        catch (Exception exception) {
            Trace.logError(this, "Failed to update DropBoxes.");
            Trace.logException(this, exception, true);
        }
    }
}

