/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.acceptor;

import com.streamscape.Trace;
import com.streamscape.lib.utils.MacroProcessor;
import com.streamscape.omf.java.Utils;
import com.streamscape.omf.odata.v4.server.jdbc.OdataDataspaceServlet;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sdo.SystemDataObject;
import com.streamscape.sef.network.LinkProtocol;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptor;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptorApplication;
import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerConfiguration;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.DataspaceFunctionRule;
import com.streamscape.sef.network.http.server.config.HTTPAuthenticationType;
import com.streamscape.sef.network.http.server.config.RealmInfo;
import com.streamscape.sef.network.http.server.config.ServletInfo;
import com.streamscape.sef.network.http.server.cors.OriginAccessControlConfiguration;
import com.streamscape.sef.network.http.server.dropbox.DropBoxConfiguration;
import com.streamscape.sef.network.http.server.jetty.JettyAdvancedProperties;
import com.streamscape.sef.network.http.server.servlet.ExchangeServlet;
import com.streamscape.sef.network.http.server.servlet.JsonExchangeServlet;
import com.streamscape.sef.network.http.server.servlet.ServiceServlet;
import com.streamscape.sef.network.http.server.servlet.SorServlet;
import com.streamscape.sef.network.http.server.servlet.dataspace.DataspaceServlet;
import com.streamscape.sef.network.http.server.swagger.SwaggerServlet;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class HTTPAcceptorConfiguration
extends CloneableDataObject
implements SystemDataObject {
    public static final String ATTRIBUTE = HTTPAcceptorConfiguration.class.getName();
    protected String name = "Default";
    protected String description = "Default HTTP acceptor";
    protected String url = "localhost:80";
    protected boolean autoStart = false;
    protected boolean abortOnFailure = false;
    protected boolean anonymousRegistration = true;
    protected boolean logEachRequest = false;
    protected boolean logExtended = false;
    protected String logDateFormat = "dd/MMM/yyyy:HH:mm:ss Z";
    protected boolean compressResponse = false;
    protected boolean storeSessions = false;
    protected String webApplicationDir = "webapps/";
    protected String webArchiveDir = "war/";
    protected int keepAliveTimeout = 15;
    protected int sessionTimeout = 1;
    protected int maxActiveSessionsNumber = -1;
    protected HTTPAuthenticationType authenticationType = HTTPAuthenticationType.DIGEST;
    protected boolean sessionAuthentication = true;
    protected boolean enableSSL = false;
    protected String keyStorePassword = "MTIzNDU2";
    protected HashMap<String, RealmInfo> realms = new HashMap();
    protected LinkedList<ServletInfo> servlets = new LinkedList();
    protected boolean enableDropBox = true;
    protected HashMap<String, String> urlToPathAliases = new HashMap();
    protected OriginAccessControlConfiguration xOriginAccessControl = new OriginAccessControlConfiguration();
    protected APICustomizerConfiguration apiCustomizer = new APICustomizerConfiguration();
    protected List<String> oAuthDelegates = new ArrayList<String>();
    protected DropBoxConfiguration dropBoxConfiguration = null;
    protected boolean requestTriggerEnabled = false;
    protected Properties advancedProperties = new Properties();
    protected long timeStamp = 0L;
    protected List<HTTPAcceptorApplication> applications = new ArrayList<HTTPAcceptorApplication>();
    private transient Properties transientAdvancedProperties = new Properties();
    private transient HTTPAcceptor acceptor;

    public HTTPAcceptorConfiguration(String name) {
        this.name = name;
        this.servlets.add(new ServletInfo("/fabric", JsonExchangeServlet.class.getName()));
        this.servlets.add(new ServletInfo("/exchange/*", ExchangeServlet.class.getName()));
        this.servlets.add(new ServletInfo("/sor/*", SorServlet.class.getName()));
        this.servlets.add(new ServletInfo("/service/*", ServiceServlet.class.getName()));
        this.servlets.add(new ServletInfo("/ds/*", DataspaceServlet.class.getName()));
        this.servlets.add(new ServletInfo("/odata/v4/*", OdataDataspaceServlet.class.getName()));
        this.servlets.add(new ServletInfo("/swagger/v2/*", SwaggerServlet.class.getName()));
        RealmInfo fabricRealm = new RealmInfo("Fabric", null);
        RealmInfo exchangeRealm = new RealmInfo("Exchange", null);
        RealmInfo sorRealm = new RealmInfo("SOR", null);
        RealmInfo serviceRealm = new RealmInfo("Service", null);
        RealmInfo dataspaceRealm = new RealmInfo("Dataspace", null);
        RealmInfo repositoryRealm = new RealmInfo("Repository", null);
        RealmInfo odataRealm = new RealmInfo("OData", null);
        RealmInfo swaggerRealm = new RealmInfo("Swagger", null);
        RealmInfo securityRealm = new RealmInfo("Security", null);
        RealmInfo chartRealm = new RealmInfo("ReactiveCharts", null);
        fabricRealm.addGroup("HTTP");
        fabricRealm.addGroup("Admins");
        fabricRealm.addGroup("Operators");
        exchangeRealm.addGroup("HTTP");
        exchangeRealm.addGroup("Admins");
        serviceRealm.addGroup("HTTP");
        serviceRealm.addGroup("Admins");
        dataspaceRealm.addGroup("HTTP");
        dataspaceRealm.addGroup("Admins");
        repositoryRealm.addGroup("HTTP");
        repositoryRealm.addGroup("Admins");
        sorRealm.addGroup("HTTP");
        sorRealm.addGroup("Admins");
        odataRealm.addGroup("HTTP");
        odataRealm.addGroup("Admins");
        swaggerRealm.addGroup("HTTP");
        swaggerRealm.addGroup("Admins");
        securityRealm.addGroup("Admins");
        chartRealm.addGroup("HTTP");
        chartRealm.addGroup("Admins");
        chartRealm.addGroup("Operators");
        this.realms.put("/fabric", fabricRealm);
        this.realms.put("/exchange", exchangeRealm);
        this.realms.put("/sor", sorRealm);
        this.realms.put("/service", serviceRealm);
        this.realms.put("/ds", dataspaceRealm);
        this.realms.put("/repository", repositoryRealm);
        this.realms.put("/odata/v4", odataRealm);
        this.realms.put("/swagger/v2", swaggerRealm);
        this.realms.put("/security", securityRealm);
        this.realms.put("/chart", chartRealm);
        DataspaceFunctionRule chartRule = new DataspaceFunctionRule();
        chartRule.setExternalURI("/chart/{payload}/{cid}");
        chartRule.setHttpMethod("GET");
        chartRule.setResponseFormat("string");
        chartRule.setResponseMimeType("application/json");
        chartRule.setDataspaceName("TSPACE.qlt$Quilt");
        chartRule.setFunctionName("chartGet");
        Properties chartRuleParameters = new Properties();
        chartRuleParameters.setProperty("payload", "uri{payload}");
        chartRuleParameters.setProperty("cid", "uri{cid}");
        chartRuleParameters.setProperty("args", "url_query{&args}");
        chartRule.setParameters(chartRuleParameters);
        try {
            this.apiCustomizer.addDataspaceRule(chartRule);
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
        }
        this.urlToPathAliases.put("/repository".substring(1), "../../../.tfcache");
        this.advancedProperties.putAll(JettyAdvancedProperties.getDefaultPropertiesAsStrings());
        this.touch();
    }

    void init(HTTPAcceptor acceptor) {
        this.acceptor = acceptor;
        if (this.realms != null) {
            this.realms.values().forEach(realm -> realm.trim());
        }
        if (acceptor.isAdmin) {
            this.sessionAuthentication = false;
        }
    }

    public String getName() {
        return this.name;
    }

    String getDescription() {
        return this.description;
    }

    void setDescription(String description) {
        this.description = description;
        this.touch();
    }

    public String getURL() {
        return this.url;
    }

    void setURL(String url) {
        this.url = url;
        this.touch();
    }

    boolean isAutoStart() {
        return this.autoStart;
    }

    void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
        this.touch();
    }

    boolean abortOnFailure() {
        return this.abortOnFailure;
    }

    void setAbortOnFailure(boolean abortOnFailure) {
        this.abortOnFailure = abortOnFailure;
        this.touch();
    }

    boolean getAnonymousRegistration() {
        return this.anonymousRegistration;
    }

    void setAnonymousRegistration(boolean anonymousRegistration) {
        this.anonymousRegistration = anonymousRegistration;
        this.touch();
    }

    public void setLogEachRequest(boolean shouldLog) {
        this.logEachRequest = shouldLog;
        this.touch();
    }

    public boolean getLogEachRequest() {
        return this.logEachRequest;
    }

    public void setLogExtended(boolean logExtended) {
        this.logExtended = logExtended;
        this.touch();
    }

    public boolean getLogExtended() {
        return this.logExtended;
    }

    public String getLogDateFormat() {
        return this.logDateFormat;
    }

    public void setLogDateFormat(String logDateFormat) {
        this.logDateFormat = logDateFormat;
    }

    public void setCompressResponse(boolean shouldCompress) {
        this.compressResponse = shouldCompress;
        this.touch();
    }

    public boolean getCompressResponse() {
        return this.compressResponse;
    }

    public void setStoreSessions(boolean shouldStore) {
        this.storeSessions = shouldStore;
        this.touch();
    }

    public boolean getStoreSessions() {
        return this.storeSessions;
    }

    public void setWebApplicationDir(String dirPath) {
        this.webApplicationDir = dirPath;
        this.touch();
    }

    public String getWebApplicationDir() {
        return this.webApplicationDir;
    }

    public void setWebArchiveDir(String dirPath) {
        this.webArchiveDir = dirPath;
        this.touch();
    }

    public String getWebArchiveDir() {
        return this.webArchiveDir;
    }

    public void setKeepAliveTimeout(int timeout) {
        this.keepAliveTimeout = timeout;
        this.touch();
    }

    public int getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setSessionTimeout(int timeout) {
        this.sessionTimeout = timeout;
        this.touch();
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setMaxActiveSessionsNumber(int sessions) {
        this.maxActiveSessionsNumber = sessions;
        this.touch();
    }

    public int getMaxActiveSessionsNumber() {
        return this.maxActiveSessionsNumber;
    }

    public void setRealms(HashMap<String, RealmInfo> realms) {
        this.realms = realms;
        if (this.acceptor != null) {
            this.realms.values().forEach(realmInfo -> realmInfo.init(this.acceptor.getRuntimeContext()));
        }
        this.touch();
    }

    public HashMap<String, RealmInfo> getRealms() {
        return this.realms;
    }

    public void setServlets(LinkedList<ServletInfo> servlets) {
        this.servlets = servlets;
        this.touch();
    }

    public LinkedList<ServletInfo> getServlets() {
        return this.servlets;
    }

    public void setUrlToPathAliases(HashMap<String, String> aliases) {
        this.urlToPathAliases = aliases;
        this.touch();
    }

    public HashMap<String, String> getUrlToPathAliases() {
        return this.urlToPathAliases;
    }

    @Override
    public Date getTimestamp() {
        return new Date(this.timeStamp);
    }

    public void setAuthenticationType(HTTPAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        this.touch();
    }

    public HTTPAuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public void setSessionAuthentication(boolean sessionAuthentication) {
        this.sessionAuthentication = sessionAuthentication;
        this.touch();
    }

    public boolean getSessionAuthentication() {
        return this.sessionAuthentication;
    }

    public void setEnableSSL(boolean enableSSL) {
        this.enableSSL = enableSSL;
        if (enableSSL && Utils.equalsNullSafe(this.url, "localhost:80")) {
            this.url = "localhost:443";
        }
        this.touch();
    }

    public boolean getEnableSSL() {
        return this.enableSSL;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
        this.touch();
    }

    public boolean isEnableDropBox() {
        return this.enableDropBox;
    }

    public void setEnableDropBox(boolean enableDropBox) {
        this.enableDropBox = enableDropBox;
        this.touch();
    }

    public OriginAccessControlConfiguration getOriginAccessControlConfiguration() {
        return this.xOriginAccessControl;
    }

    public void setOriginAccessControlConfiguration(OriginAccessControlConfiguration crossOrigin) {
        this.xOriginAccessControl = crossOrigin;
        this.touch();
    }

    public APICustomizerConfiguration getAPICustomizerConfiguration() {
        return this.apiCustomizer;
    }

    public void setAPICustomizerConfiguration(APICustomizerConfiguration apiCustomizer) {
        this.apiCustomizer = apiCustomizer;
        this.touch();
    }

    public List<String> getOAuthDelegates() {
        return this.oAuthDelegates;
    }

    public void setOAuthDelegates(List<String> oAuthDelegates) {
        this.oAuthDelegates = oAuthDelegates;
    }

    public boolean isRequestTriggerEnabled() {
        return this.requestTriggerEnabled;
    }

    public void setRequestTriggerEnabled(boolean requestTriggerEnabled) {
        this.requestTriggerEnabled = requestTriggerEnabled;
    }

    public Properties getAdvancedProperties() {
        return this.advancedProperties;
    }

    public void setAdvancedProperties(Properties serverProperties) {
        this.advancedProperties = serverProperties;
    }

    public Properties getTransientAdvancedProperties() {
        if (this.transientAdvancedProperties == null) {
            this.transientAdvancedProperties = new Properties();
        }
        return this.transientAdvancedProperties;
    }

    @Override
    public void touch() {
        this.timeStamp = System.currentTimeMillis();
    }

    public String getResolvedUrlWithoutSchema() {
        String resolvedUrl = new MacroProcessor().process(this.url);
        int pos = resolvedUrl.indexOf("://");
        if (pos != -1) {
            resolvedUrl = resolvedUrl.substring(pos + 3);
        }
        return resolvedUrl;
    }

    public String getResolvedUrlWithSchema() {
        return (this.enableSSL ? LinkProtocol.HTTPS : LinkProtocol.HTTP).getURLPrefix() + this.getResolvedUrlWithoutSchema();
    }

    public List<HTTPAcceptorApplication> getApplications() {
        if (this.applications == null) {
            this.applications = new ArrayList<HTTPAcceptorApplication>();
        }
        return new ArrayList<HTTPAcceptorApplication>(this.applications);
    }

    public HTTPAcceptorConfiguration setApplications(List<HTTPAcceptorApplication> applications) {
        this.applications = applications;
        return this;
    }

    @Override
    public HTTPAcceptorConfiguration clone() {
        HTTPAcceptorConfiguration copy = (HTTPAcceptorConfiguration)super.clone();
        if (this.realms != null) {
            copy.realms = (HashMap)this.realms.clone();
        }
        if (this.servlets != null) {
            copy.servlets = (LinkedList)this.servlets.clone();
        }
        if (this.urlToPathAliases != null) {
            copy.urlToPathAliases = new HashMap<String, String>(this.urlToPathAliases);
        }
        if (this.advancedProperties != null) {
            copy.advancedProperties = new Properties(this.advancedProperties);
        }
        if (this.applications != null) {
            copy.applications = new ArrayList<HTTPAcceptorApplication>(this.applications);
        }
        return copy;
    }
}

