/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.acceptor;

import com.streamscape.sef.network.http.acceptor.HTTPAcceptorApplication;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptorConfiguration;
import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerConfiguration;
import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerException;
import com.streamscape.sef.network.http.server.apicustomizer.AbstractRule;
import com.streamscape.sef.network.http.server.apicustomizer.any.AnyRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class HTTPAcceptorApplicationsUtils {
    public static final String DASHBOARD = "dashboard";
    public static final String RTAI = "rtai";
    public static final String RTAI_COOKIE_VALUE = "rtai";
    public static final String OS = "os";
    public static final String OS_COOKIE_VALUE = "os";
    public static final String CID_COOKIE_NAME = "cid";
    public static final String VIEW_COOKIE_NAME = "view";

    public static void addAcceptorApplication(HTTPAcceptorConfiguration configuration, HTTPAcceptorApplication application) throws APICustomizerException {
        APICustomizerConfiguration customizerConfiguration = configuration.getAPICustomizerConfiguration();
        if (customizerConfiguration == null) {
            customizerConfiguration = new APICustomizerConfiguration();
            configuration.setAPICustomizerConfiguration(customizerConfiguration);
        }
        List<HTTPAcceptorApplication> applications = configuration.getApplications();
        HTTPAcceptorApplicationsUtils.checkAcceptorApplication(customizerConfiguration, applications, application);
        HTTPAcceptorApplicationsUtils.removeAcceptorApplication(configuration, application);
        applications.add(application);
        HTTPAcceptorApplicationsUtils.addApplicationRule(customizerConfiguration, application.getRelativeUrl(DASHBOARD), "rtai", application.getCid());
        configuration.setApplications(applications);
    }

    public static void removeAcceptorApplication(HTTPAcceptorConfiguration configuration, String applicationName) throws APICustomizerException {
        HTTPAcceptorApplication application = configuration.getApplications().stream().filter(a -> a.getName().equals(applicationName)).findAny().orElse(null);
        if (application == null) {
            throw new RuntimeException("Application " + applicationName + " doesn't exist.");
        }
        HTTPAcceptorApplicationsUtils.removeAcceptorApplication(configuration, application);
    }

    public static void removeAcceptorApplication(HTTPAcceptorConfiguration configuration, HTTPAcceptorApplication application) throws APICustomizerException {
        List<HTTPAcceptorApplication> applications = configuration.getApplications();
        applications.removeIf(a -> a.getName().equals(application.getName()));
        HTTPAcceptorApplicationsUtils.removeAcceptorApplicationFromCustomizer(configuration, application);
        configuration.setApplications(applications);
    }

    public static void removeAcceptorApplicationFromCustomizer(HTTPAcceptorConfiguration configuration, HTTPAcceptorApplication application) throws APICustomizerException {
        APICustomizerConfiguration customizerConfiguration = configuration.getAPICustomizerConfiguration();
        HTTPAcceptorApplicationsUtils.removeApplicationRule(customizerConfiguration, application.getRelativeUrl(DASHBOARD));
    }

    public static void checkAcceptorApplication(APICustomizerConfiguration customizerConfiguration, List<HTTPAcceptorApplication> applications, HTTPAcceptorApplication application) {
        if (applications.stream().filter(a -> a.getName().equals(application.getName())).count() > 0L) {
            throw new RuntimeException("Application with name " + application.getName() + " already exists.");
        }
        List applicationsContainingThisUrl = applications.stream().filter(a -> a.getUrl().equals(application.getRelativeUrl()) || a.getUrl().startsWith(application.getUrl() + "/")).map(a -> a.getUrl()).collect(Collectors.toList());
        if (applicationsContainingThisUrl.size() > 0) {
            throw new RuntimeException("There are already applications containing this application URL: " + String.valueOf(applicationsContainingThisUrl));
        }
        List applicationsUnderThisUrl = applications.stream().filter(a -> application.getUrl().startsWith(a.getUrl() + "/")).map(a -> a.getUrl()).collect(Collectors.toList());
        if (applicationsUnderThisUrl.size() > 0) {
            throw new RuntimeException("There are already applications under this application URL: " + String.valueOf(applicationsContainingThisUrl));
        }
        List ruleExternalUrls = customizerConfiguration.listAllRules().stream().filter(r -> r.getExternalURI().startsWith(application.getRelativeUrl(DASHBOARD) + "/")).map(r -> r.getExternalURI()).collect(Collectors.toList());
        if (ruleExternalUrls.size() > 0) {
            throw new RuntimeException("There are already customizer rules win extrenal URL containgin this application URL: " + String.valueOf(ruleExternalUrls));
        }
    }

    public static List<String> checkApplicationRules(HTTPAcceptorConfiguration configuration, HTTPAcceptorApplication application) {
        ArrayList<String> errors = new ArrayList<String>();
        String applicationUrl = "/" + application.getRelativeUrl(DASHBOARD);
        List<AbstractRule> applicationRules = HTTPAcceptorApplicationsUtils.listApplicationRules(configuration, application);
        Consumer<String> checkRule = url -> {
            List rule = applicationRules.stream().filter(r -> r.getExternalURI().equals(url)).collect(Collectors.toList());
            if (rule.size() == 0) {
                errors.add("Rule for URL '" + url + "' is missing.");
            }
            if (rule.size() > 1) {
                errors.add("There are more than one rules for URL '" + url + "'.");
            }
        };
        checkRule.accept(applicationUrl);
        checkRule.accept(applicationUrl + "/");
        checkRule.accept(applicationUrl + "/{+}");
        if (applicationRules.size() > 3) {
            errors.add("There are moro rules(" + applicationRules.size() + ") than needed(3).");
        }
        return errors;
    }

    public static List<AbstractRule> listApplicationRules(HTTPAcceptorConfiguration configuration, HTTPAcceptorApplication application) {
        return new ArrayList<AbstractRule>(configuration.getAPICustomizerConfiguration().listAnyRules().stream().filter(r -> r.getExternalURI().startsWith("/" + application.getRelativeUrl(DASHBOARD))).collect(Collectors.toList()));
    }

    public static void removeRulesForOsAndDash(HTTPAcceptorConfiguration configuration) throws APICustomizerException {
        APICustomizerConfiguration customizerConfiguration = configuration.getAPICustomizerConfiguration();
        if (customizerConfiguration != null) {
            HTTPAcceptorApplicationsUtils.removeApplicationRule(customizerConfiguration, "os");
            HTTPAcceptorApplicationsUtils.removeApplicationRule(customizerConfiguration, "rtai");
        }
    }

    private static void removeApplicationRule(APICustomizerConfiguration customizerConfiguration, String uri) throws APICustomizerException {
        List<AnyRule> rules = customizerConfiguration.listAnyRules();
        rules = rules.stream().filter(r -> !r.getExternalURI().equalsIgnoreCase("/" + uri)).filter(r -> !r.getExternalURI().equalsIgnoreCase("/" + uri + "/")).filter(r -> !r.getExternalURI().equalsIgnoreCase("/" + uri + "/{+}")).collect(Collectors.toList());
        customizerConfiguration.setAnyRules(new ArrayList<AnyRule>(rules));
    }

    public static void addRulesForOsAndDash(HTTPAcceptorConfiguration configuration) throws APICustomizerException {
        APICustomizerConfiguration customizerConfiguration = configuration.getAPICustomizerConfiguration();
        if (customizerConfiguration == null) {
            customizerConfiguration = new APICustomizerConfiguration();
            configuration.setAPICustomizerConfiguration(customizerConfiguration);
        }
        HTTPAcceptorApplicationsUtils.addApplicationRule(customizerConfiguration, "os", "os", null);
        HTTPAcceptorApplicationsUtils.addApplicationRule(customizerConfiguration, "rtai", "rtai", null);
        HTTPAcceptorApplicationsUtils.hideApplication(customizerConfiguration, "sysadmin");
    }

    private static void hideApplication(APICustomizerConfiguration customizerConfiguration, String name) throws APICustomizerException {
        List<AnyRule> rules = customizerConfiguration.listAnyRules();
        AnyRule rule = rules.stream().filter(r -> r.getExternalURI().equalsIgnoreCase("/" + name)).findAny().orElse(null);
        if (rule == null) {
            rule = new AnyRule();
        }
        rule.setExternalURI("/" + name);
        rule.setHttpMethod("GET");
        rule.setReturnCode(404);
        rule.setErrorCode(404);
        rule.setCustomizedUri("/" + name + "-application-not-found");
        rule.setCustomizedMethod("GET");
        rules.remove(rule);
        customizerConfiguration.addAnyRule(rule);
        rule = rules.stream().filter(r -> r.getExternalURI().equalsIgnoreCase("/" + name + "/")).findAny().orElse(null);
        if (rule == null) {
            rule = new AnyRule();
        }
        rule.setExternalURI("/" + name + "/");
        rule.setHttpMethod("GET");
        rule.setReturnCode(404);
        rule.setErrorCode(404);
        rule.setCustomizedUri("/" + name + "-application-not-found/");
        rule.setCustomizedMethod("GET");
        rules.remove(rule);
        customizerConfiguration.addAnyRule(rule);
    }

    private static void addApplicationRule(APICustomizerConfiguration customizerConfiguration, String name, String cookieValue, String cid) throws APICustomizerException {
        List<AnyRule> rules = customizerConfiguration.listAnyRules();
        AnyRule rule = rules.stream().filter(r -> r.getExternalURI().equalsIgnoreCase("/" + name)).findAny().orElse(null);
        if (rule == null) {
            rule = new AnyRule();
        }
        rule.setExternalURI("/" + name);
        rule.setHttpMethod("GET");
        rule.setReturnCode(200);
        rule.setErrorCode(0);
        rule.setCustomizedUri("/" + name + "/");
        rule.setCustomizedMethod("GET");
        rule.setRedirect(true);
        rules.remove(rule);
        customizerConfiguration.addAnyRule(rule);
        rule = rules.stream().filter(r -> r.getExternalURI().equalsIgnoreCase("/" + name + "/")).findAny().orElse(null);
        if (rule == null) {
            rule = new AnyRule();
        }
        rule.setExternalURI("/" + name + "/");
        rule.setHttpMethod("GET");
        rule.setReturnCode(200);
        rule.setErrorCode(0);
        rule.setCustomizedUri("/sysadmin/");
        rule.setCustomizedMethod("GET");
        rule.setRedirect(false);
        Properties cookies = new Properties();
        cookies.setProperty(VIEW_COOKIE_NAME, cookieValue);
        if (cid != null) {
            cookies.setProperty(CID_COOKIE_NAME, cid);
        }
        rule.setCookies(cookies);
        rules.remove(rule);
        customizerConfiguration.addAnyRule(rule);
        rule = rules.stream().filter(r -> r.getExternalURI().equalsIgnoreCase("/" + name + "/{+}")).findAny().orElse(null);
        if (rule == null) {
            rule = new AnyRule();
        }
        rule.setExternalURI("/" + name + "/{+}");
        rule.setHttpMethod("GET");
        rule.setReturnCode(200);
        rule.setErrorCode(0);
        rule.setCustomizedUri("/sysadmin/uri{+}");
        rule.setCustomizedMethod("GET");
        rule.setRedirect(false);
        rule.setCookies(null);
        rules.remove(rule);
        customizerConfiguration.addAnyRule(rule);
    }
}

