/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.acceptor;

import com.streamscape.Trace;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.network.LinkProtocol;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptorConfiguration;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptorFactory;
import com.streamscape.sef.network.http.server.apicustomizer.APICustomizer;
import com.streamscape.sef.network.http.server.jetty.JettyServer;
import com.streamscape.sef.network.mf.admin.AbstractAcceptor;
import com.streamscape.sef.network.mf.admin.Acceptor;
import com.streamscape.sef.network.mf.admin.AcceptorException;
import java.io.File;

public class HTTPAcceptor
extends AbstractAcceptor
implements Acceptor {
    protected HTTPAcceptorConfiguration configuration;
    transient JettyServer server;
    transient boolean isNewlyCreated = true;
    transient boolean isAdmin = false;

    public HTTPAcceptor() {
        this("Default");
        Trace.logDebug(this, "Creating Default HTTP Acceptor..");
    }

    public HTTPAcceptor(String acceptorName) {
        this.configuration = new HTTPAcceptorConfiguration(acceptorName);
        Trace.logDebug(this, "Initialized HTTP Acceptor '" + acceptorName + "'.");
    }

    public HTTPAcceptor(String acceptorName, boolean isAdmin) {
        this(acceptorName);
        this.isAdmin = isAdmin;
    }

    @Override
    public void init(RuntimeContext context) throws Exception {
        super.init(context);
        this.configuration.init(this);
        this.initRealms();
    }

    private void initRealms() throws Exception {
        this.configuration.getRealms().values().forEach(realmInfo -> realmInfo.init(this.context));
    }

    @Override
    public LinkProtocol getProtocol() {
        return this.enableSSL() ? LinkProtocol.HTTPS : LinkProtocol.HTTP;
    }

    @Override
    protected boolean isSuitableProtocol(LinkProtocol protocol) {
        return protocol == LinkProtocol.HTTP || protocol == LinkProtocol.HTTPS;
    }

    @Override
    public String getName() {
        return this.configuration.getName();
    }

    @Override
    public String getDescription() {
        return this.configuration.getDescription();
    }

    @Override
    public void setDescription(String description) {
        this.configuration.setDescription(description);
    }

    @Override
    public String getURL() {
        return this.configuration.getURL();
    }

    @Override
    protected void doSetURL(String url) {
        this.configuration.setURL(url);
    }

    @Override
    public boolean autoStart() {
        return this.configuration.isAutoStart();
    }

    @Override
    public void setAutoStart(boolean autoStart) {
        this.configuration.setAutoStart(autoStart);
    }

    @Override
    public boolean abortOnFailure() {
        return this.configuration.abortOnFailure();
    }

    @Override
    public void setAbortOnFailure(boolean abortOnFailure) {
        this.configuration.setAbortOnFailure(abortOnFailure);
    }

    @Override
    public boolean anonymousRegistration() {
        return this.configuration.getAnonymousRegistration();
    }

    @Override
    public void setAnonymousRegistration(boolean anonymousRegistration) {
        this.configuration.setAnonymousRegistration(anonymousRegistration);
    }

    @Override
    public boolean enableSSL() {
        return this.configuration.getEnableSSL();
    }

    @Override
    protected void doSetEnableSSL(boolean enableSSL) {
        this.configuration.setEnableSSL(enableSSL);
    }

    @Override
    protected void doStart() throws AcceptorException {
        try {
            if (this.server != null) {
                return;
            }
            this.server = new JettyServer(this.context, this);
            this.server.start();
        }
        catch (Exception exception) {
            throw new AcceptorException(6002, "Starting HTTP acceptor '" + this.getName() + "' failed.", exception);
        }
    }

    @Override
    protected void doStop() throws AcceptorException {
        try {
            if (this.server == null) {
                return;
            }
            this.server.stop();
            this.server = null;
        }
        catch (Exception exception) {
            throw new AcceptorException(6002, "Stopping HTTP acceptor '" + this.getName() + "' failed.", exception);
        }
    }

    public HTTPAcceptorFactory getHTTPAcceptorFactory() {
        return (HTTPAcceptorFactory)this.factory;
    }

    @Override
    protected String getPrefix() {
        return "HTTP Acceptor";
    }

    @Override
    protected void doValidate() throws Exception {
        super.doValidate();
        try {
            APICustomizer.validate(this.configuration.getAPICustomizerConfiguration());
        }
        catch (Exception exception) {
            Trace.logError(this, "Failed to validate API Customizer");
            Trace.logException(this, exception, true);
        }
    }

    public HTTPAcceptorConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void destroy() {
        try {
            this.doStop();
        }
        catch (AcceptorException exception) {
            Trace.logException(this, exception, true);
        }
    }

    public boolean isNewlyCreated() {
        return this.isNewlyCreated;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public String getHttpDir() {
        return String.valueOf(this.context.getEnvironment().get("streamscape.runtime.startup.dir")) + File.separator + ".htcache" + File.separator;
    }

    public String getWorkingDir() {
        return this.getHttpDir() + this.getName() + File.separator;
    }

    public String getWebArchiveDir() {
        return this.getWorkingDir() + File.separator + this.configuration.getWebArchiveDir() + File.separator;
    }

    public String getWebApplicationDir() {
        return this.getWorkingDir() + File.separator + this.configuration.getWebApplicationDir() + File.separator;
    }

    public String getHtmlDir() {
        return this.getWorkingDir() + "html" + File.separator;
    }
}

