/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network;

import com.streamscape.lib.utils.Pair;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.network.Address;
import com.streamscape.sef.network.LinkProtocol;

public class LinkAddress
implements Comparable<LinkAddress> {
    private LinkProtocol protocol = LinkProtocol.TLP;
    private Address address = new Address();

    public static LinkProtocol checkFormat(String url) throws FabricException {
        Pair<LinkProtocol, Integer> protocol = LinkAddress.getProtocol(url);
        Address.checkFormat(url.substring((Integer)protocol.second + "://".length()));
        return (LinkProtocol)((Object)protocol.first);
    }

    public LinkAddress(Address address) {
        this(LinkProtocol.TLP, address);
    }

    public LinkAddress(LinkProtocol protocol, Address address) {
        this.protocol = protocol;
        this.address = address;
    }

    public LinkAddress(String url) throws FabricException {
        Pair<LinkProtocol, Integer> pair = LinkAddress.getProtocol(url);
        this.protocol = (LinkProtocol)((Object)pair.first);
        try {
            this.address = new Address(url.substring((Integer)pair.second + 3));
            if (this.address.getAddress() == null) {
                throw new FabricException("URL cannot be resolved.");
            }
        }
        catch (IllegalArgumentException exception) {
            throw new FabricException("URL has wrong format (" + exception.toString() + ").");
        }
        catch (SecurityException exception) {
            throw new FabricException("URL has wrong format (" + exception.toString() + ").");
        }
    }

    private static Pair<LinkProtocol, Integer> getProtocol(String url) throws FabricException {
        if (url == null) {
            throw new FabricException("URL is null.");
        }
        int delimiterIndex = url.indexOf("://");
        if (delimiterIndex == -1) {
            throw new FabricException("URL has wrong format (delimiter '://' missed).");
        }
        try {
            return new Pair<LinkProtocol, Integer>(LinkProtocol.fromString(url.substring(0, delimiterIndex)), delimiterIndex);
        }
        catch (IllegalArgumentException exception) {
            throw new FabricException("URL has wrong format (invalid protocol).");
        }
    }

    public static LinkProtocol extractProtocol(String url) throws FabricException {
        int index = url.indexOf("://");
        if (index != -1) {
            try {
                return LinkProtocol.fromString(url.substring(0, index));
            }
            catch (IllegalArgumentException exception) {
                throw new FabricException("URL has wrong format (invalid protocol).");
            }
        }
        return null;
    }

    public static String extractAddress(String url) {
        int index = url.indexOf("://");
        return index != -1 ? url.substring(index + 3) : url;
    }

    public LinkProtocol getProtocol() {
        return this.protocol;
    }

    public Address getAddress() {
        return this.address;
    }

    public String toString() {
        return this.protocol.toString() + "://" + this.address.toString();
    }

    public boolean equals(Object other) {
        return this == other || other instanceof LinkAddress && this.protocol.equals((Object)((LinkAddress)other).protocol) && this.address.equals(((LinkAddress)other).address);
    }

    @Override
    public int compareTo(LinkAddress other) {
        return this.toString().compareTo(other.toString());
    }
}

