/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network;

import com.streamscape.lib.utils.Pair;
import com.streamscape.sef.FabricException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.StringTokenizer;

public class Address
extends InetSocketAddress {
    public static void checkFormat(String url) throws FabricException {
        Address.splitURL(url);
    }

    public Address() {
        super("localhost", 5000);
    }

    public Address(int port) {
        super("localhost", port);
    }

    public Address(String hostname, int port) {
        super(hostname, port);
    }

    public Address(InetAddress address, int port) {
        super(address, port);
    }

    public Address(InetSocketAddress socketAddress) {
        super(socketAddress.getAddress(), socketAddress.getPort());
    }

    public Address(String url) throws FabricException {
        this(Address.splitURL(url));
    }

    protected Address(Pair<String, Integer> hostAndPort) throws FabricException {
        super((String)hostAndPort.first, (int)((Integer)hostAndPort.second));
    }

    protected static Pair<String, Integer> splitURL(String url) throws FabricException {
        if (url == null) {
            throw new FabricException("URL is null.");
        }
        StringTokenizer tokenizer = new StringTokenizer(url, ":", false);
        if (tokenizer.countTokens() == 2) {
            try {
                return new Pair<String, Integer>(tokenizer.nextToken(), Integer.parseInt(tokenizer.nextToken()));
            }
            catch (NumberFormatException exception) {
                throw new FabricException("URL has wrong format (port is not a valid number).");
            }
        }
        if (tokenizer.countTokens() == 1) {
            throw new FabricException("URL has wrong format (port is absent).");
        }
        throw new FabricException("URL has wrong format (too many delimiters).");
    }

    @Override
    public String toString() {
        return (this.getAddress() != null ? this.getAddress().getHostAddress() : this.getHostName()) + ":" + this.getPort();
    }
}

