/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.moderator;

import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.exchange.FabricAddress;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.moderator.ExchangeRole;
import com.streamscape.sef.moderator.Moderator;
import com.streamscape.sef.utils.Utils;
import java.util.ArrayList;
import java.util.List;

public class ModeratorUtils {
    public static boolean containsNodeName(String componentFullName) {
        return componentFullName.contains("://");
    }

    public static int getNodeNameIndex(String componentFullName) {
        return componentFullName.indexOf("://");
    }

    public static String extractNodeName(String componentFullName) {
        int iDelimiter = ModeratorUtils.getNodeNameIndex(componentFullName);
        return iDelimiter == -1 ? null : componentFullName.substring(0, iDelimiter);
    }

    public static String extractComponentName(String componentFullName) {
        int iDelimiter = ModeratorUtils.getNodeNameIndex(componentFullName);
        return iDelimiter == -1 ? componentFullName : componentFullName.substring(iDelimiter + "://".length());
    }

    public static String extractComponentNameType(String componentFullName) {
        String componentName = ModeratorUtils.extractComponentName(componentFullName);
        int iDelimiter = componentName.lastIndexOf(".");
        return iDelimiter == -1 ? null : componentName.substring(0, iDelimiter);
    }

    public static String extractComponentNameName(String componentFullName) {
        String componentName = ModeratorUtils.extractComponentName(componentFullName);
        int iDelimiter = componentName.lastIndexOf(".");
        return iDelimiter == -1 ? componentName : componentName.substring(iDelimiter + 1);
    }

    public static String extractComponentNameFromConsumerName(String consumerFullName) {
        int iDelimiter = consumerFullName.lastIndexOf(":");
        return iDelimiter == -1 ? consumerFullName : consumerFullName.substring(0, iDelimiter);
    }

    public static String getNodeNameWithDelimiter(String nodeName) {
        return nodeName + "://";
    }

    public static String makeComponentFullName(String componentType, String componentName) {
        return (String)(componentType != null ? componentType + "." : "") + componentName;
    }

    public static String makeComponentFullName(String nodeName, String componentType, String componentName) {
        return nodeName != null ? ModeratorUtils.getNodeNameWithDelimiter(nodeName) + ModeratorUtils.makeComponentFullName(componentType, componentName) : ModeratorUtils.makeComponentFullName(componentType, componentName);
    }

    public static String checkComponentFullName(String nodeName, String componentFullName) {
        return nodeName != null && !ModeratorUtils.containsNodeName(componentFullName) ? ModeratorUtils.getNodeNameWithDelimiter(nodeName) + componentFullName : componentFullName;
    }

    public static String makeConsumerFullName(String componentType, String componentName, String consumerName) {
        return ModeratorUtils.makeConsumerFullName(ModeratorUtils.makeComponentFullName(componentType, componentName), consumerName);
    }

    public static String makeConsumerFullName(String nodeName, String componentType, String componentName, String consumerName) {
        return ModeratorUtils.makeConsumerFullName(ModeratorUtils.makeComponentFullName(nodeName, componentType, componentName), consumerName);
    }

    public static String makeComponentFullName(FabricComponent component) {
        return ModeratorUtils.makeComponentFullName(null, component);
    }

    public static String makeComponentFullName(FabricConnection connection) {
        return ModeratorUtils.makeComponentFullName(null, connection);
    }

    public static String makeComponentFullName(String nodeName, FabricComponent component) {
        return ModeratorUtils.makeComponentFullName(nodeName, component.getType(), component.getName());
    }

    public static String makeComponentFullName(String nodeName, FabricConnection connection) {
        return ModeratorUtils.makeComponentFullName(nodeName, connection.getType(), connection.getName());
    }

    public static String makeConsumerFullName(FabricComponent component, String consumerName) {
        return ModeratorUtils.makeConsumerFullName(null, component, consumerName);
    }

    public static String makeConsumerFullName(FabricConnection connection, String consumerName) {
        return ModeratorUtils.makeConsumerFullName(null, connection, consumerName);
    }

    public static String makeConsumerFullName(String nodeName, FabricComponent component, String consumerName) {
        return ModeratorUtils.makeConsumerFullName(nodeName, component.getType(), component.getName(), consumerName);
    }

    public static String makeConsumerFullName(String nodeName, FabricConnection connection, String consumerName) {
        return ModeratorUtils.makeConsumerFullName(nodeName, connection.getType(), connection.getName(), consumerName);
    }

    public static String makeConsumerFullName(ComponentReference component, String consumerName) {
        return ModeratorUtils.makeConsumerFullName(component.getName(), consumerName);
    }

    public static String makeConsumerFullName(String componentFullName, String consumerName) {
        return componentFullName + ":" + consumerName;
    }

    public static List<String> splitComponentFullName(String name) throws FabricException {
        return ModeratorUtils.splitComponentFullName(name, false);
    }

    public static List<String> splitComponentFullName(String name, boolean skipNodeName) throws FabricException {
        ArrayList<String> result = new ArrayList<String>();
        int iDelimiter = ModeratorUtils.getNodeNameIndex(name);
        if (!skipNodeName) {
            ModeratorUtils.checkFormat(iDelimiter != -1, "component", name, "Node name is missed.");
        }
        if (iDelimiter != -1) {
            result.add(name.substring(0, iDelimiter));
            StringUtils.split(name.substring(iDelimiter + "://".length()), '.', result);
            ModeratorUtils.checkFormat(result.size() == 3, "component", name);
        } else {
            StringUtils.split(name, '.', result);
            ModeratorUtils.checkFormat(result.size() == 2, "component", name);
        }
        return result;
    }

    public static List<String> splitConsumerFullName(String name) throws FabricException {
        return ModeratorUtils.doSplitConsumerFullName(name, "consumer");
    }

    public static List<String> splitReplicationSourceFullName(String name) throws FabricException {
        return ModeratorUtils.doSplitConsumerFullName(name, "replication source");
    }

    private static List<String> doSplitConsumerFullName(String name, String entity) throws FabricException {
        ArrayList<String> result = new ArrayList<String>(4);
        int iBegin = ModeratorUtils.getNodeNameIndex(name);
        ModeratorUtils.checkFormat(iBegin != -1, entity, name);
        result.add(name.substring(0, iBegin));
        int iEnd = name.indexOf(46, iBegin += "://".length());
        ModeratorUtils.checkFormat(iEnd != -1, entity, name);
        result.add(name.substring(iBegin, iEnd));
        iBegin = iEnd + 1;
        ModeratorUtils.checkFormat(iBegin < name.length(), entity, name);
        iEnd = name.indexOf(58, iBegin);
        ModeratorUtils.checkFormat(iEnd != -1, entity, name);
        result.add(name.substring(iBegin, iEnd));
        iBegin = iEnd + 1;
        ModeratorUtils.checkFormat(iBegin < name.length(), entity, name);
        result.add(name.substring(iBegin));
        return result;
    }

    public static List<String> splitReplicationTargetFullName(String name) throws FabricException {
        String entity = "replication target";
        ArrayList<String> result = new ArrayList<String>(5);
        int iBegin = ModeratorUtils.getNodeNameIndex(name);
        ModeratorUtils.checkFormat(iBegin != -1, entity, name);
        result.add(name.substring(0, iBegin));
        int iEnd = name.indexOf(46, iBegin += "://".length());
        ModeratorUtils.checkFormat(iEnd != -1, entity, name);
        result.add(name.substring(iBegin, iEnd));
        iBegin = iEnd + 1;
        ModeratorUtils.checkFormat(iBegin < name.length(), entity, name);
        iEnd = name.indexOf(58, iBegin);
        ModeratorUtils.checkFormat(iEnd != -1, entity, name);
        result.add(name.substring(iBegin, iEnd));
        iBegin = iEnd + 1;
        ModeratorUtils.checkFormat(iBegin < name.length(), entity, name);
        iEnd = name.indexOf(46, iBegin);
        ModeratorUtils.checkFormat(iEnd != -1, entity, name);
        result.add(name.substring(iBegin, iEnd));
        iBegin = iEnd + 1;
        ModeratorUtils.checkFormat(iBegin < name.length(), entity, name);
        result.add(name.substring(iBegin));
        return result;
    }

    private static void checkFormat(boolean condition, String entity, String name) throws FabricException {
        Utils.check(condition, "Invalid " + entity + " name '" + name + "'.");
    }

    private static void checkFormat(boolean condition, String entity, String name, String cause) throws FabricException {
        Utils.check(condition, "Invalid " + entity + " name '" + name + "'. Cause: " + cause);
    }

    public static String getConsumerMode(ExchangeRole exchangeRole) {
        switch (exchangeRole) {
            case ASYNC_CONSUMER: {
                return "Async";
            }
            case DIRECT_CONSUMER: {
                return "Direct";
            }
            case RECEIVER: {
                return "Receiver";
            }
            case REQUEST_CONSUMER: {
                return "Request";
            }
        }
        throw new RuntimeException("Invalid ExchangeRole!");
    }

    public static String extractConsumerName(String fullName) {
        int index = fullName.lastIndexOf(58);
        return index != -1 ? fullName.substring(index + 1) : null;
    }

    public static ComponentReference lookupComponent(Moderator moderator, ImmutableEventDatagram event) {
        return moderator.lookupComponent(new FabricAddress(event.getEventSource()));
    }
}

