/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.mf.admin.module;

import com.streamscape.Trace;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.runtime.mf.admin.obj.ObjectConfigurationException;
import com.streamscape.runtime.mf.admin.obj.SemanticObjectReferenceStore;
import com.streamscape.sef.dispatcher.AbstractFabricContextFactory;
import com.streamscape.sef.mf.admin.module.Module;
import com.streamscape.sef.mf.admin.module.ModuleConfiguration;
import com.streamscape.sef.mf.admin.module.ModuleFactoryException;
import com.streamscape.sef.utils.RepositoryUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ModuleFactory
extends AbstractFabricContextFactory {
    protected boolean repositoryEnabled;
    private Map<String, ModuleConfiguration> modules = new HashMap<String, ModuleConfiguration>();
    private ModuleConfiguration activeModule;

    protected abstract String getModuleType();

    protected abstract Class getModuleConfigurationClass();

    protected abstract String getModuleNamespace();

    protected abstract Class getModuleClass();

    protected abstract Class getDefaultModuleClass();

    protected abstract ModuleConfiguration createModuleConfiguration(String var1, String var2, String var3, Map<String, String> var4);

    protected ModuleFactory(boolean repositoryEnabled) {
        this.repositoryEnabled = repositoryEnabled;
    }

    protected void init() throws ModuleFactoryException {
        this.initSemanticTypes();
        if (this.repositoryEnabled) {
            this.loadModules();
        }
        this.addDefaultModule();
    }

    protected abstract void initSemanticTypes() throws ModuleFactoryException;

    protected void loadModules() throws ModuleFactoryException {
        Trace.logDebug(this, "Loading " + this.getModuleType() + " modules...");
        try {
            SemanticObjectReferenceStore.beginXact();
            SemanticObjectReferenceStore.setReferenceContext(RepositoryUtils.getReferenceContext(this.getModuleNamespace(), true, true));
            for (String moduleName : SemanticObjectReferenceStore.listBoundNames(null)) {
                Object object = SemanticObjectReferenceStore.lookup(moduleName);
                if (this.getModuleConfigurationClass().isAssignableFrom(object.getClass())) {
                    this.modules.put(moduleName, (ModuleConfiguration)object);
                    continue;
                }
                Trace.logError(this, "Object '" + moduleName + "' is not instance of " + String.valueOf(this.getModuleConfigurationClass()) + " and will be ignored.");
            }
            SemanticObjectReferenceStore.commitXact();
        }
        catch (Throwable exception) {
            SemanticObjectReferenceStore.abortXactSafe();
            throw new ModuleFactoryException("Loading " + this.getModuleType() + " modules failed.", exception, ModuleFactoryException.ErrorCode.INITIALIZATION_FAILED);
        }
        Trace.logInfo(this, this.getModuleType() + " modules loaded.");
    }

    protected void addDefaultModule() throws ModuleFactoryException {
        if (!this.modules.containsKey("Default")) {
            this.addModule("Default", "Default " + this.getModuleType() + " module of the Fabric.", this.getDefaultModuleClass().getName(), this.getDefaultModuleParameters());
        }
    }

    protected Map<String, String> getDefaultModuleParameters() {
        return null;
    }

    protected void destroy() {
        if (this.activeModule != null) {
            this.activeModule.destroyModule();
            this.activeModule = null;
        }
    }

    public synchronized void addModule(String name, String description, String moduleClass, Map<String, String> parameters) throws ModuleFactoryException {
        if (this.modules.containsKey(name)) {
            throw new ModuleFactoryException(this.getModuleType() + " module '" + name + "' already exists.", ModuleFactoryException.ErrorCode.MODULE_ALREADY_EXISTS);
        }
        try {
            ModuleConfiguration module = this.createModuleConfiguration(name, description, moduleClass, parameters);
            if (this.repositoryEnabled) {
                RepositoryUtils.bindObject(this.getModuleNamespace(), name, (Object)module);
            }
            this.modules.put(name, module);
        }
        catch (Exception exception) {
            throw new ModuleFactoryException("Binding of " + this.getModuleType() + " module '" + name + "' to repository failed.", exception, ModuleFactoryException.ErrorCode.REPOSITORY_ERROR);
        }
    }

    public synchronized void removeModule(String name) throws ModuleFactoryException {
        if (name.equals("Default")) {
            throw new ModuleFactoryException("Default " + this.getModuleType() + " module cannot be removed.", ModuleFactoryException.ErrorCode.MODULE_REMOVING_FAILED);
        }
        if (this.isModuleActive(name)) {
            throw new ModuleFactoryException(this.getModuleType() + " module '" + name + "' is active and cannot be removed.", ModuleFactoryException.ErrorCode.MODULE_REMOVING_FAILED);
        }
        if (this.modules.remove(name) != null && this.repositoryEnabled) {
            try {
                RepositoryUtils.unbindObject(this.getModuleNamespace(), name);
            }
            catch (Exception exception) {
                throw new ModuleFactoryException("Unbinding " + this.getModuleType() + " module '" + name + "' from repository failed.", exception, ModuleFactoryException.ErrorCode.REPOSITORY_ERROR);
            }
        }
    }

    public ModuleConfiguration getActiveModuleConfiguration() {
        return this.activeModule;
    }

    public synchronized ModuleConfiguration getModuleConfiguration(String name) {
        return this.modules.get(name);
    }

    public synchronized boolean existsModule(String name) {
        return this.modules.containsKey(name);
    }

    public synchronized List<String> listModules() {
        return new ArrayList<String>(this.modules.keySet());
    }

    protected synchronized void activateModule(String name) throws ModuleFactoryException {
        ModuleConfiguration newActiveModule = this.modules.get(name);
        if (newActiveModule == null) {
            throw new ModuleFactoryException(this.getModuleType() + " module '" + name + "' does not exist.", ModuleFactoryException.ErrorCode.MODULE_NOT_EXIST);
        }
        if (newActiveModule.equals(this.activeModule)) {
            throw new ModuleFactoryException(this.getModuleType() + " module '" + name + "' is already active.", ModuleFactoryException.ErrorCode.MODULE_ALREADY_ACTIVE);
        }
        Trace.logDebug(this, "Activating " + this.getModuleType() + " module '" + newActiveModule.getName() + "'...");
        try {
            Trace.logDebug(ModuleFactory.class, "Initializing " + this.getModuleType() + " module '" + newActiveModule.getName() + "'...");
            Class moduleClass = ClassUtils.loadClass(newActiveModule.getModuleClass(), context.getSystemClassLoaderChain());
            if (!this.getModuleClass().isAssignableFrom(moduleClass)) {
                throw new ModuleFactoryException("Module class '" + newActiveModule.getModuleClass() + "' is not instance of " + String.valueOf(this.getModuleClass()) + ".", ModuleFactoryException.ErrorCode.INVALID_MODULE_CLASS);
            }
            newActiveModule.setModule((Module)moduleClass.newInstance(), this);
            newActiveModule.initModule(context);
            Trace.logInfo(this, this.getModuleType() + " module '" + newActiveModule.getName() + "' initialized.");
        }
        catch (Exception exception) {
            throw new ModuleFactoryException("Initialization of " + this.getModuleType() + " module '" + newActiveModule.getName() + "' failed.", exception, ModuleFactoryException.ErrorCode.MODULE_INITIALIZATION_FAILED);
        }
        if (this.activeModule != null) {
            Trace.logDebug(this, "Destroying previously active " + this.getModuleType() + " module '" + this.activeModule.getName() + "'...");
            this.activeModule.destroyModule();
            Trace.logInfo(this, this.getModuleType() + " module '" + this.activeModule.getName() + "' destroyed.");
        }
        this.activeModule = newActiveModule;
        this.onModuleActivation(this.activeModule.getModule());
        Trace.logInfo(this, this.getModuleType() + " module '" + this.activeModule.getName() + "' activated.");
    }

    protected abstract void onModuleActivation(Module var1);

    public boolean isModuleActive(String name) {
        return this.activeModule != null && this.activeModule.getName().equals(name);
    }

    public synchronized void saveModule(ModuleConfiguration configuration) throws ModuleFactoryException {
        if (this.repositoryEnabled) {
            if (!this.modules.containsKey(configuration.getName())) {
                throw new ModuleFactoryException(this.getModuleType() + " module '" + configuration.getName() + "' does not exist.", ModuleFactoryException.ErrorCode.MODULE_NOT_EXIST);
            }
            try {
                RepositoryUtils.bindObject(this.getModuleNamespace(), configuration.getName(), (Object)configuration);
            }
            catch (ObjectConfigurationException exception) {
                throw new ModuleFactoryException("Update " + this.getModuleType() + " module '" + configuration.getName() + "' in repository failed.", exception, ModuleFactoryException.ErrorCode.REPOSITORY_ERROR);
            }
        }
    }
}

