/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.mf.admin.module;

import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sef.mf.admin.FabricContext;
import com.streamscape.sef.mf.admin.module.AbstractModule;
import com.streamscape.sef.mf.admin.module.Module;
import com.streamscape.sef.mf.admin.module.ModuleException;
import com.streamscape.sef.mf.admin.module.ModuleFactory;
import com.streamscape.sef.mf.admin.module.ModuleFactoryException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModuleConfiguration
extends CloneableDataObject {
    private String name;
    private String description;
    private String moduleClass;
    private Map<String, String> parameters;
    private transient Module module;
    private transient ModuleFactory moduleFactory;

    protected ModuleConfiguration(String name, String description, String moduleClass, Map<String, String> parameters) {
        this.name = name;
        this.description = description;
        this.moduleClass = moduleClass;
        this.parameters = parameters;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getModuleClass() {
        return this.moduleClass;
    }

    public synchronized String getParameter(String name) {
        return this.parameters != null ? this.parameters.get(name) : null;
    }

    public synchronized void setParameter(String name, String value) throws ModuleException {
        if (this.module != null) {
            this.module.setParameter(name, value);
        }
        this.doSetParameter(name, value);
    }

    protected void doSetParameter(String name, String value) throws ModuleException {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
        this.parameters.put(name, value);
        try {
            if (this.moduleFactory != null) {
                this.moduleFactory.saveModule(this);
            }
        }
        catch (ModuleFactoryException exception) {
            throw new ModuleException(6025, "Saving module '" + this.getName() + "' failed.", exception);
        }
    }

    public List<String> listParameters() {
        return this.parameters != null ? new ArrayList<String>(this.parameters.keySet()) : new ArrayList();
    }

    protected Module getModule() {
        return this.module;
    }

    void setModule(Module module, ModuleFactory moduleFactory) {
        this.module = module;
        this.moduleFactory = moduleFactory;
    }

    void initModule(FabricContext context) throws ModuleException {
        if (this.module instanceof AbstractModule) {
            ((AbstractModule)this.module).setConfiguration(this);
        }
        this.module.init(context, this.parameters);
    }

    void destroyModule() {
        this.module.destroy();
        this.module = null;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof ModuleConfiguration && this.name.equals(((ModuleConfiguration)other).name);
    }
}

