/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.mf.admin;

import com.streamscape.Trace;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.omf.xml.XSerializerFactory;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.mf.admin.obj.ObjectConfigurationException;
import com.streamscape.sdo.mf.admin.SemanticTypeFactoryException;
import com.streamscape.sdo.mf.admin.TypeFactory;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.dispatcher.AbstractRuntimeFactory;
import com.streamscape.sef.utils.RepositoryUtils;

public abstract class ExchangeObjectFactory<T>
extends AbstractRuntimeFactory {
    public synchronized T create() throws FabricException {
        if (!this.isCreated()) {
            try {
                this.addSemanticTypesAndAliases();
            }
            catch (Exception exception) {
                throw new FabricException("Initialization of '" + this.getObjectName() + "' factory failed.", exception);
            }
            T result = this.doCreate();
            this.setCreated(true);
            return result;
        }
        throw new FabricException("'" + this.getObjectName() + "' already exists.");
    }

    protected T doCreate() throws FabricException {
        Object result;
        try {
            result = RepositoryUtils.lookupObject(this.getObjectNamespace(), this.getObjectName(), this::createDefaultObject);
            this.processCreatedObject(result);
        }
        catch (ObjectConfigurationException exception) {
            throw new FabricException("Obtaining '" + this.getObjectName() + "' from repository failed.", exception);
        }
        return (T)result;
    }

    public synchronized void destroy() {
        this.setCreated(false);
    }

    public void updateObject(T object) {
        try {
            RepositoryUtils.bindObject(this.getObjectNamespace(), this.getObjectName(), object);
        }
        catch (ObjectConfigurationException exception) {
            this.logException(exception);
            this.logError("Update '" + this.getObjectName() + "' in repository failed.");
        }
    }

    protected abstract boolean isCreated();

    protected abstract void setCreated(boolean var1);

    protected abstract T createDefaultObject();

    protected static void addSemanticType(String typeName, Class typeClass) throws SemanticTypeFactoryException {
        SemanticType type = ExchangeObjectFactory.createSemanticType(typeName, typeClass, true);
        type.setDescription("Autogenerated Exchange type.");
        TypeFactory.addSemanticType(type);
    }

    protected abstract Class getObjectClass();

    protected abstract String getObjectNamespace();

    protected abstract String getObjectName();

    protected void addSemanticTypesAndAliases() throws Exception {
    }

    protected void processCreatedObject(T object) {
    }

    protected XSerializer getSerializer() {
        return ExchangeObjectFactory.getContext() != null ? ExchangeObjectFactory.getContext().getXSerializerFactory().lookupSerializer("RuntimeCache$Serializer") : XSerializerFactory.getInstance().getDefaultSerializer();
    }

    protected void logException(Throwable exception) {
        Trace.logException(this, exception, true);
    }

    protected void logError(String message) {
        Trace.logError(this, message);
    }

    protected void logInfo(String message) {
        Trace.logInfo(this, message);
    }

    protected void logDebug(String message) {
        Trace.logDebug(this, message);
    }
}

