/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.metrics;

import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sdo.SystemDataObject;
import com.streamscape.sdo.enums.Unit;
import com.streamscape.sef.metrics.Metric;
import com.streamscape.sef.metrics.MetricDefinition;
import com.streamscape.sef.metrics.MetricThresholdListener;
import java.util.Date;
import java.util.TimerTask;

public class RuntimeMetric
extends CloneableDataObject
implements SystemDataObject,
Metric {
    private String metricName = null;
    private String metricDescription = null;
    private long minThreshold = 0L;
    private long maxThreshold = 0L;
    private String units = null;
    private long incrementUnits = 1L;
    private boolean notifyOnThreshold = false;
    private long metricTimeStamp = 0L;
    private long metricValue = 0L;
    private long resetInterval = 0L;
    private transient boolean xMax = false;
    private transient boolean xMin = false;
    private transient MetricThresholdListener listener = null;
    private transient ResetIntervalTimerTask resetIntervalTimerTask = null;

    public RuntimeMetric(MetricDefinition metric) {
        this.metricName = metric.getName();
        this.metricDescription = metric.getDescription();
        this.minThreshold = metric.getMinThreshold();
        this.maxThreshold = metric.getMaxThreshold();
        this.units = metric.getUnits().name();
        this.incrementUnits = metric.getIncrementUnits();
        this.notifyOnThreshold = metric.hasNotification();
        this.resetInterval = metric.getResetInterval();
        this.metricValue = 0L;
        this.touch();
    }

    @Override
    public String getName() {
        return this.metricName;
    }

    protected void setName(String name) {
        this.metricName = name;
    }

    public void setListener(MetricThresholdListener thListener) {
        this.listener = thListener;
    }

    protected void setDescription(String description) {
        this.metricDescription = description;
    }

    @Override
    public String getDescription() {
        return this.metricDescription;
    }

    protected void setMinThreshold(long threshold) {
        this.minThreshold = threshold;
    }

    @Override
    public long getMinThreshold() {
        return this.minThreshold;
    }

    protected void setMaxThreshold(long threshold) {
        this.maxThreshold = threshold;
    }

    @Override
    public long getMaxThreshold() {
        return this.maxThreshold;
    }

    protected void setUnits(Unit unit) {
        this.units = unit.name();
    }

    @Override
    public Unit getUnits() {
        return Unit.valueOf(this.units);
    }

    protected void setIncrementUnits(long units) {
        this.incrementUnits = units;
    }

    @Override
    public long getIncrementUnits() {
        return this.incrementUnits;
    }

    protected void setNotificationEnabled(boolean notify) {
        this.notifyOnThreshold = notify;
    }

    @Override
    public boolean hasNotification() {
        return this.notifyOnThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setValue(long value) {
        RuntimeMetric runtimeMetric = this;
        synchronized (runtimeMetric) {
            this.metricValue = value;
            this.touch();
            if (this.metricValue > this.maxThreshold) {
                if (!this.xMax) {
                    this.xMax = true;
                    if (this.notifyOnThreshold && this.listener != null) {
                        this.listener.onThreshold(this.getName());
                    }
                }
            } else {
                this.xMax = false;
            }
            if (this.metricValue < this.minThreshold) {
                if (!this.xMin) {
                    this.xMin = true;
                    if (this.notifyOnThreshold && this.listener != null) {
                        this.listener.onThreshold(this.getName());
                    }
                }
            } else {
                this.xMin = false;
            }
        }
    }

    protected void nextValue() {
        this.setValue(this.metricValue + this.incrementUnits);
    }

    protected void priorValue() {
        this.setValue(this.metricValue - this.incrementUnits);
    }

    @Override
    public long getValue() {
        return this.metricValue;
    }

    @Override
    public Date getMetricTimestamp() {
        return this.getTimestamp();
    }

    protected void setResetInterval(long resetInterval) {
        this.resetInterval = resetInterval;
    }

    @Override
    public long getResetInterval() {
        return this.resetInterval;
    }

    protected synchronized ResetIntervalTimerTask getResetIntervalTimerTask() {
        if (this.resetIntervalTimerTask == null) {
            this.resetIntervalTimerTask = new ResetIntervalTimerTask();
        }
        return this.resetIntervalTimerTask;
    }

    @Override
    public Date getTimestamp() {
        return new Date(this.metricTimeStamp);
    }

    @Override
    public void touch() {
        this.metricTimeStamp = System.currentTimeMillis();
    }

    @Override
    public boolean isMaxThreshold() {
        return this.xMax;
    }

    @Override
    public boolean isMinThreshold() {
        return this.xMin;
    }

    protected class ResetIntervalTimerTask
    extends TimerTask {
        protected ResetIntervalTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RuntimeMetric runtimeMetric = RuntimeMetric.this;
            synchronized (runtimeMetric) {
                RuntimeMetric.this.metricValue = 0L;
                RuntimeMetric.this.xMax = false;
                RuntimeMetric.this.xMin = false;
            }
        }
    }
}

