/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.metrics;

import com.streamscape.lib.utils.StringUtils;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sdo.enums.Unit;
import com.streamscape.sef.FabricComponentConfigurationException;

public class MetricDefinition
extends CloneableDataObject {
    private String metricName = "";
    private String metricDescription = "";
    private long minThreshold = 0L;
    private long maxThreshold = 0L;
    private String units = Unit.Times.name();
    private long incrementUnits = 1L;
    private boolean notifyOnThreshold = false;
    private long resetInterval = 0L;

    public MetricDefinition() {
    }

    public MetricDefinition(String metricName) throws FabricComponentConfigurationException {
        if (!StringUtils.validateObjectName(metricName)) {
            throw new FabricComponentConfigurationException("Invalid Metric name '" + metricName + "' specified.");
        }
        this.metricName = metricName;
    }

    public String getName() {
        return this.metricName;
    }

    public void setName(String metricName) throws FabricComponentConfigurationException {
        if (!StringUtils.validateObjectName(metricName)) {
            throw new FabricComponentConfigurationException("Invalid Metric name '" + metricName + "' specified.");
        }
        this.metricName = metricName;
    }

    public void setDescription(String description) {
        this.metricDescription = description;
    }

    public String getDescription() {
        return this.metricDescription;
    }

    public void setMinThreshold(long threshold) {
        this.minThreshold = threshold;
    }

    public Long getMinThreshold() {
        return this.minThreshold;
    }

    public void setMaxThreshold(long threshold) {
        this.maxThreshold = threshold;
    }

    public long getMaxThreshold() {
        return this.maxThreshold;
    }

    public void setUnits(Unit unit) {
        this.units = unit.name();
    }

    public Unit getUnits() {
        return Unit.valueOf(this.units);
    }

    public void setIncrementUnits(long units) {
        this.incrementUnits = units;
    }

    public long getIncrementUnits() {
        return this.incrementUnits;
    }

    public void setNotificationEnabled(boolean notify) {
        this.notifyOnThreshold = notify;
    }

    public boolean hasNotification() {
        return this.notifyOnThreshold;
    }

    public void setResetInterval(long resetInterval) {
        this.resetInterval = resetInterval;
    }

    public long getResetInterval() {
        return this.resetInterval;
    }

    @Override
    public MetricDefinition clone() {
        return (MetricDefinition)super.clone();
    }
}

