/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.keys;

import com.streamscape.lib.utils.Utils;
import com.streamscape.sef.keys.SSSecurityKeyAlgorithm;
import com.streamscape.sef.keys.SSSecurityKeyEntry;
import com.streamscape.sef.keys.SSSecurityKeyEntryImpl;
import com.streamscape.sef.keys.SSSecurityKeyException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.UUID;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class SSSecurityKeyGenerator {
    private SSSecurityKeyAlgorithm algorithm;
    private String name;
    private String uuid;
    private long createdAt;
    private String ownerName;
    private boolean isPublic = false;

    public static SSSecurityKeyGenerator algorithm(SSSecurityKeyAlgorithm algorithm) {
        return new SSSecurityKeyGenerator(algorithm);
    }

    private SSSecurityKeyGenerator(SSSecurityKeyAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public SSSecurityKeyGenerator setName(String name) {
        this.name = name;
        return this;
    }

    public SSSecurityKeyGenerator setUuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    public SSSecurityKeyGenerator setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public SSSecurityKeyGenerator setOwnerName(String ownerName) {
        this.ownerName = ownerName;
        return this;
    }

    public SSSecurityKeyGenerator setPublic(boolean isPublic) {
        this.isPublic = isPublic;
        return this;
    }

    public SSSecurityKeyEntry generate() {
        SecretKey secretKey = null;
        PrivateKey privateKey = null;
        PublicKey publicKey = null;
        KeyPairGenerator gen = null;
        try {
            switch (this.algorithm) {
                case RSA: {
                    gen = KeyPairGenerator.getInstance(this.algorithm.getName());
                    gen.initialize(2048);
                    break;
                }
                case ES256: {
                    gen = KeyPairGenerator.getInstance("EC");
                    gen.initialize(new ECGenParameterSpec("secp256r1"));
                    break;
                }
                case ES384: {
                    gen = KeyPairGenerator.getInstance("EC");
                    gen.initialize(new ECGenParameterSpec("secp384r1"));
                    break;
                }
                case ES512: {
                    gen = KeyPairGenerator.getInstance("EC");
                    gen.initialize(new ECGenParameterSpec("secp521r1"));
                    break;
                }
                case HS256: {
                    secretKey = KeyGenerator.getInstance("HmacSha256").generateKey();
                    break;
                }
                case HS384: {
                    secretKey = KeyGenerator.getInstance("HmacSha384").generateKey();
                    break;
                }
                case HS512: {
                    secretKey = KeyGenerator.getInstance("HmacSha512").generateKey();
                }
            }
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException exception) {
            throw new SSSecurityKeyException(Utils.formatExceptionWithUnrepeatedCauses(exception), exception);
        }
        if (gen != null) {
            KeyPair keyPair = gen.generateKeyPair();
            privateKey = keyPair.getPrivate();
            publicKey = keyPair.getPublic();
        }
        return new SSSecurityKeyEntryImpl(this.algorithm, this.name, this.uuid != null ? this.uuid : UUID.randomUUID().toString(), System.currentTimeMillis(), this.ownerName, this.isPublic, secretKey, privateKey, publicKey);
    }

    public SSSecurityKeyEntry createFrom(byte[] secretKeyBytes, byte[] privateKeyBytes, byte[] publicKeyBytes) {
        SecretKeySpec secretKey = null;
        PrivateKey privateKey = null;
        PublicKey publicKey = null;
        KeyFactory keyFactory = null;
        try {
            switch (this.algorithm) {
                case RSA: {
                    keyFactory = KeyFactory.getInstance("RSA");
                    break;
                }
                case ES256: 
                case ES384: 
                case ES512: {
                    keyFactory = KeyFactory.getInstance("EC");
                    break;
                }
                case HS256: {
                    secretKey = new SecretKeySpec(secretKeyBytes, 0, secretKeyBytes.length, "HmacSha256");
                    break;
                }
                case HS384: {
                    secretKey = new SecretKeySpec(secretKeyBytes, 0, secretKeyBytes.length, "HmacSha384");
                    break;
                }
                case HS512: {
                    secretKey = new SecretKeySpec(secretKeyBytes, 0, secretKeyBytes.length, "HmacSha512");
                }
            }
            if (keyFactory != null) {
                privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(privateKeyBytes));
                publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(publicKeyBytes));
            }
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException exception) {
            throw new SSSecurityKeyException(Utils.formatExceptionWithUnrepeatedCauses(exception), exception);
        }
        return new SSSecurityKeyEntryImpl(this.algorithm, this.name, this.uuid != null ? this.uuid : UUID.randomUUID().toString(), this.createdAt, this.ownerName, this.isPublic, secretKey, privateKey, publicKey);
    }
}

