/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.keys;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.dispatcher.AbstractSSSecurityKeyEntryProvider;
import com.streamscape.sef.keys.SSSecurityKeyEntry;
import com.streamscape.sef.security.SecurityManagerException;
import com.streamscape.sef.security.User;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public final class SSSecurityKeyEntryProviderNoKeys
extends AbstractSSSecurityKeyEntryProvider {
    public SSSecurityKeyEntryProviderNoKeys(RuntimeContext context) {
        super(context);
    }

    public List<SSSecurityKeyEntry> listEntriesVisibleByUser(String username) {
        List<SSSecurityKeyEntry> result = super.listEntries();
        try {
            User user = this.context.getSecurityManager().lookupUser(username);
            if (user != null && user.isAdministrator()) {
                return result;
            }
        }
        catch (SecurityManagerException securityManagerException) {
            // empty catch block
        }
        return new ArrayList<SSSecurityKeyEntry>(result.stream().filter(e -> e.isPublic() || e.getOwnerName().equalsIgnoreCase(username)).collect(Collectors.toList()));
    }

    public SSSecurityKeyEntry getEntryByAlias(String alias) {
        SSSecurityKeyEntry entry = this.getEntryByNameInternal(alias);
        if (entry != null) {
            entry = entry.copyWithoutKeys();
        }
        return entry;
    }

    public SSSecurityKeyEntry getEntryByUUID(String uuid) {
        SSSecurityKeyEntry entry = this.getEntryByUUIDInternal(uuid);
        if (entry != null) {
            entry = entry.copyWithoutKeys();
        }
        return entry;
    }
}

