/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.keys;

import com.streamscape.sef.keys.SSSecurityKeyAlgorithm;
import com.streamscape.sef.keys.SSSecurityKeyEntry;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.SecretKey;

public class SSSecurityKeyEntryImpl
implements SSSecurityKeyEntry {
    private SSSecurityKeyAlgorithm algorithm;
    private String name;
    private String uuid;
    private long createdAt;
    private String ownerName;
    private boolean isPublic;
    private SecretKey secretKey;
    private PrivateKey privateKey;
    private PublicKey publicKey;
    private boolean isSecretKeyPresent;
    private boolean isPrivateKeyPresent;
    private boolean isPublicKeyPresent;

    public SSSecurityKeyEntryImpl(SSSecurityKeyAlgorithm algorithm, String name, String uuid, long createdAt, String ownerName, boolean isPublic, SecretKey secretKey, PrivateKey privateKey, PublicKey publicKey) {
        this.algorithm = algorithm;
        this.name = name;
        this.uuid = uuid;
        this.createdAt = createdAt;
        this.ownerName = ownerName;
        this.isPublic = isPublic;
        this.secretKey = secretKey;
        this.privateKey = privateKey;
        this.publicKey = publicKey;
    }

    @Override
    public SSSecurityKeyAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUUID() {
        return this.uuid;
    }

    @Override
    public long getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public String getOwnerName() {
        return this.ownerName;
    }

    @Override
    public boolean isPublic() {
        return this.isPublic;
    }

    @Override
    public SecretKey getSecretKey() {
        return this.secretKey;
    }

    @Override
    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public boolean isSecretKeyPresent() {
        return this.secretKey != null || this.isSecretKeyPresent;
    }

    @Override
    public boolean isPrivateKeyPresent() {
        return this.privateKey != null || this.isPrivateKeyPresent;
    }

    @Override
    public boolean isPublicKeyPresent() {
        return this.publicKey != null || this.isPublicKeyPresent;
    }

    @Override
    public SSSecurityKeyEntry copyWithoutKeys() {
        SSSecurityKeyEntryImpl copy = new SSSecurityKeyEntryImpl(this.algorithm, this.name, this.uuid, this.createdAt, this.ownerName, this.isPublic, this.secretKey, this.privateKey, this.publicKey);
        copy.isSecretKeyPresent = copy.secretKey != null;
        copy.isPrivateKeyPresent = copy.privateKey != null;
        copy.isPublicKeyPresent = copy.publicKey != null;
        copy.secretKey = null;
        copy.privateKey = null;
        copy.publicKey = null;
        return copy;
    }
}

