/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.factory.connection.external;

import com.streamscape.sef.factory.connection.external.AbstractCompoundExecutionStatement;
import com.streamscape.sef.factory.connection.external.ExecutionStatement;
import com.streamscape.sef.factory.connection.external.ExternalParser;
import com.streamscape.sef.factory.connection.external.ExternalParserContext;
import com.streamscape.tools.lexer.CommonTokenType;
import com.streamscape.tools.lexer.Lexer;
import com.streamscape.tools.lexer.LexerException;
import com.streamscape.tools.lexer.LexerFactory;
import com.streamscape.tools.parser.ParserException;
import com.streamscape.tools.parser.ParserExceptionBuilder;

public abstract class AbstractExternalParser
implements ExternalParser {
    protected Lexer<LexerFactory.DummyTokenType> lexer;
    protected ExternalParserContext<?> externalParserContext;

    @Override
    public ExecutionStatement parse(String script, ExternalParserContext<?> externalParserContext) throws ParserException {
        try {
            this.lexer = LexerFactory.createLexer(script);
            this.lexer.reset(script);
        }
        catch (LexerException exception) {
            throw new ParserException(null, "Failed to create lexer. Cause: " + exception.getMessage());
        }
        this.externalParserContext = externalParserContext;
        return this.onParse();
    }

    protected abstract ExecutionStatement onParse() throws ParserException;

    protected void parsePartsCompoundQuery(AbstractCompoundExecutionStatement statement) throws ParserException {
        try {
            if (this.lexer.isCurrentToken(CommonTokenType.STRING_LITERAL)) {
                statement.addPart(this.readExternalStatement());
                if (this.supportsStatementParameters()) {
                    this.lexer.readToken();
                    while (this.lexer.isCurrentToken(CommonTokenType.COMMA)) {
                        this.lexer.readToken();
                        statement.addArgument(this.readExternalStatement());
                        this.lexer.readToken();
                    }
                    if (!this.lexer.isCurrentToken(CommonTokenType.CLOSE_BRACKET)) {
                        throw this.lexer.unexpectedTokenException(CommonTokenType.CLOSE_BRACKET);
                    }
                } else {
                    this.lexer.readToken(CommonTokenType.CLOSE_BRACKET);
                }
            } else {
                this.parseQuery(this.externalParserContext, statement);
            }
        }
        catch (LexerException exception) {
            throw ParserExceptionBuilder.parserException(this.lexer, exception.getMessage());
        }
        if (statement.toString().trim().length() == 0) {
            throw ParserExceptionBuilder.parserException(this.lexer, "Invalid query. Should be not empty.");
        }
        if (this.externalParserContext != null) {
            this.externalParserContext.setPosition(this.lexer.getCurrentTokenPosition());
        }
    }

    private void parseQuery(ExternalParserContext<?> externalParserContext, AbstractCompoundExecutionStatement statement) throws LexerException, ParserException {
        block4: {
            int position = this.lexer.getCurrentTokenPosition();
            do {
                if (this.lexer.isCurrentToken(CommonTokenType.DOG)) {
                    this.appendFromLexer(position, statement);
                    statement.addPart(this.readExternalStatement());
                    this.lexer.readToken();
                    position = this.lexer.getCurrentTokenPosition();
                    continue;
                }
                if (this.lexer.isCurrentToken(CommonTokenType.OPEN_BRACKET)) {
                    this.lexer.readToken();
                    this.appendFromLexer(position, statement);
                    this.parseQuery(externalParserContext, statement);
                    position = this.lexer.getCurrentTokenPosition();
                    this.lexer.readToken();
                    continue;
                }
                if (this.lexer.isCurrentToken(CommonTokenType.CLOSE_BRACKET)) {
                    this.appendFromLexer(position, statement);
                    break block4;
                }
                this.lexer.readToken();
            } while (!this.lexer.isCurrentToken(CommonTokenType.BUFFER_END));
            this.appendFromLexer(position, statement);
        }
    }

    protected void appendFromLexer(int position, AbstractCompoundExecutionStatement statement) {
        if (position < this.lexer.getCurrentTokenPosition()) {
            statement.addPart(this.lexer.substring(position, this.lexer.getCurrentTokenPosition()));
        }
    }

    protected Object readExternalStatement() throws ParserException {
        int position = this.lexer.getCurrentTokenPosition();
        try {
            this.externalParserContext.setPosition(position);
            Object externalExpression = this.externalParserContext.parseExpression();
            this.lexer.rewind(this.externalParserContext.getPosition());
            return externalExpression;
        }
        catch (Exception exception) {
            this.lexer.rewind(position);
            throw ParserExceptionBuilder.parserException(this.lexer, "Failed to parse SQL query. Cause: " + exception.getMessage());
        }
    }

    @Override
    public void setCompleteMode(boolean completeMode) {
    }

    protected abstract boolean supportsStatementParameters();
}

