/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.factory.connection.external;

import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.sef.factory.connection.external.ExecutionStatement;
import com.streamscape.sef.factory.connection.external.ExternalExecutionContext;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public abstract class AbstractCompoundExecutionStatement
implements ExecutionStatement {
    protected List<Object> parts = new ArrayList<Object>();
    private List<Object> arguments = new ArrayList<Object>();

    public void addPart(Object part) {
        this.parts.add(part);
    }

    public void addArgument(Object argument) {
        this.arguments.add(argument);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Object part : this.parts) {
            builder.append(part);
        }
        return builder.toString();
    }

    @Override
    public List<Object> getExternalExpressions() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object part : this.parts) {
            if (part instanceof String) continue;
            result.add(part);
        }
        return result;
    }

    protected String buildQuery(ExternalExecutionContext executionContext) {
        StringBuilder queryBuilder = new StringBuilder();
        for (Object part : this.parts) {
            if (part instanceof Expression) {
                Expression expression = (Expression)part;
                Object value = executionContext.getValue(expression);
                if (value instanceof String && this.parts.size() != 1) {
                    queryBuilder.append("'").append(((String)value).replace("'", "''")).append("'");
                    continue;
                }
                queryBuilder.append(value);
                continue;
            }
            queryBuilder.append(" ").append(part).append(" ");
        }
        return queryBuilder.toString();
    }

    protected List<Object> buildArguments(ExternalExecutionContext executionContext) {
        return this.arguments.stream().map(a -> {
            if (a instanceof Expression) {
                return executionContext.getValue(a);
            }
            return a;
        }).collect(Collectors.toList());
    }
}

