/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.factory.connection;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLCallable;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.parameter.NumericParameter;

public class AbstractSetFetchSizeOperation<T extends SLCallable>
extends AbstractDSLOperation<T> {
    public static final String NAME = "set fetch size";
    public static String description = "Sets the size of resulting RowSet's buffer used by the TLP protocol when transferring tabular results.\nThis option controls how many rows are returned in a single data fetch operation across the network and\napplies to any tabular results returned by SLANG or to Connection Factories accessed by SLANG.\nValue of 0 means downloading all rows. Value of -1 means use of a default fetch size.\nFor example, connection factories that access relational databases will use this value to set the JDBC Fetch Size\nand MongoDB connections will use this value to set Batch Size for query results.\n\nSome experimentation will be needed to determine optimal settings for a given situation so mileage will vary.";

    public AbstractSetFetchSizeOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SET FETCH SIZE").addActionParameter(new NumericParameter("FetchSize"));
        this.syntax.setDescription(description);
        this.syntax.addTag(OperationTag.session);
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(Integer.parseInt(statement.getParameter("FetchSize").getValue()));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        try {
            Definition definition = (Definition)statement;
            if (definition.fetchSize < -1) {
                throw new Exception("Fetch size should be greater or equals to -1.");
            }
            session.getSLSessionData().setFetchSize(definition.fetchSize);
            return new SLResponse();
        }
        catch (Exception exception) {
            throw new Exception(exception.getMessage());
        }
    }

    public static class Definition
    extends AbstractSLStatement {
        private int fetchSize;

        protected Definition(int fetchSize) {
            super(AbstractSetFetchSizeOperation.NAME);
            this.fetchSize = fetchSize;
        }
    }
}

