/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.types;

import com.streamscape.sef.evtrigger.function.types.Type;

public class ValueConversionException
extends Exception {
    private Object value;
    private Type<?> valueType;
    private Type<?> toType;
    private String message;

    public ValueConversionException(String message) {
        this(message, null);
    }

    public ValueConversionException(String message, Throwable cause) {
        super(cause);
        this.message = message;
    }

    public ValueConversionException(Object value, Type<?> valueType, Type<?> toType, Throwable cause) {
        super(cause);
        this.value = value;
        this.valueType = valueType;
        this.toType = toType;
    }

    @Override
    public String getMessage() {
        if (this.message != null) {
            return this.getCause() != null && this.getCause().getMessage() != null ? this.message + " Cause: " + this.getCause().getMessage() : this.message;
        }
        Object valueStr = null;
        valueStr = this.valueType != null ? this.valueType.escapeValue(this.value) + " of type '" + this.valueType.getName() + "'" : (this.value == null ? "null" : this.value.toString());
        return "Failed to convert value " + (String)valueStr + " to type '" + this.toType.getName() + "'." + (String)(this.getCause() != null && this.getCause().getMessage() != null ? " Cause: " + this.getCause().getMessage() : "");
    }

    public Object getValue() {
        return this.value;
    }

    public Type<?> getValueType() {
        return this.valueType;
    }

    public Type<?> getToType() {
        return this.toType;
    }
}

